/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFFFace;
import com.identix.uidai.cbeff.ImageStruct;
import com.identix.util.Utility;
import java.io.File;
import java.math.BigInteger;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacialISO {
    public static final int FACIAL_HEADER_LENGTH = 14;
    public static final int IMAGE_HEADER_LENGTH = 32;
    public static final int FACIAL_POINT_LENGTH = 8;
    private static final Logger LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.FacialISO");

    public static byte[] packageImage(byte[] image, int file_type, int width, int height) {
        int j;
        byte[] ihd = FacialISO.getImageHeader(image.length, file_type, width, height);
        byte[] output = new byte[14 + ihd.length + image.length];
        output[0] = 70;
        output[1] = 65;
        output[2] = 67;
        output[3] = 0;
        output[4] = 48;
        output[5] = 49;
        output[6] = 48;
        output[7] = 0;
        byte[] len = Utility.intToByteArray(image.length + 14 + ihd.length, 4);
        output[8] = len[0];
        output[9] = len[1];
        output[10] = len[2];
        output[11] = len[3];
        output[12] = 0;
        output[13] = Utility.smallIntToByte(1);
        int i = 14;
        for (j = 0; j < ihd.length; ++j) {
            output[i] = ihd[j];
            ++i;
        }
        i = 14 + ihd.length;
        for (j = 0; j < image.length; ++j) {
            output[i] = image[j];
            ++i;
        }
        return output;
    }

    public static String inspectHeader(byte[] input) throws Exception {
        if (input == null) {
            throw new Exception("No data passed to parse!");
        }
        String details = new String("");
        details = details + "{actual_size=\"" + input.length + "\",";
        details = details + "format=\"" + input[0] + input[1] + input[2] + input[3] + "\",";
        details = details + "version=\"" + input[4] + input[5] + input[6] + input[7] + "\",";
        byte[] all_length = new byte[]{input[8], input[9], input[10], input[11]};
        int all_length_int = new BigInteger(all_length).intValue();
        details = details + "length=\"" + all_length_int + "\",";
        byte[] facial_count = new byte[]{input[12], input[13]};
        int facial_count_int = new BigInteger(facial_count).intValue();
        details = details + "facial_ct=\"" + facial_count_int + "\",";
        int j = 14;
        for (int i = 0; i < facial_count_int; ++i) {
            details = details + "(Face#" + (i + 1) + ":";
            byte[] tmp_image_size = new byte[]{input[j++], input[j++], input[j++], input[j++]};
            int tmp_image_size_int = new BigInteger(tmp_image_size).intValue();
            details = details + "img_size=\"" + tmp_image_size_int + "\",";
            byte[] tmp_face_pts = new byte[]{input[j++], input[j++]};
            int tmp_face_pts_int = new BigInteger(tmp_face_pts).intValue();
            details = details + "feature_pts=\"" + tmp_face_pts_int + "\",";
            int image_data_size = tmp_image_size_int - 32 - 8 * tmp_face_pts_int;
            byte[] tmp_gender = new byte[]{input[j++]};
            int tmp_gender_int = new BigInteger(tmp_gender).intValue();
            details = details + "gender=\"" + tmp_gender_int + "\",";
            byte[] tmp_eye_col = new byte[]{input[j++]};
            int tmp_eye_col_int = new BigInteger(tmp_eye_col).intValue();
            details = details + "eye_col=\"" + tmp_eye_col_int + "\",";
            byte[] tmp_hair_col = new byte[]{input[j++]};
            int tmp_hair_col_int = new BigInteger(tmp_hair_col).intValue();
            details = details + "hair_col=\"" + tmp_hair_col_int + "\",";
            byte[] tmp_prop_mask = new byte[]{input[j++], input[j++], input[j++]};
            int[] tmp_prop_mask_ints = Utility.getBitArray(tmp_prop_mask);
            details = details + "prop_mask=\"" + Utility.intArrayToString(tmp_prop_mask_ints) + "\",";
            byte[] tmp_exp = new byte[]{input[j++], input[j++]};
            int tmp_exp_int = new BigInteger(tmp_exp).intValue();
            details = details + "exp=\"" + tmp_exp_int + "\",";
            byte[] tmp_pose_angle_y = new byte[]{input[j++], input[j++], input[j++]};
            int tmp_pose_ang_y_int = new BigInteger(tmp_pose_angle_y).intValue();
            byte[] tmp_pose_angle_p = new byte[]{input[j++], input[j++], input[j++]};
            int tmp_pose_ang_p_int = new BigInteger(tmp_pose_angle_p).intValue();
            byte[] tmp_pose_angle_r = new byte[]{input[j++], input[j++], input[j++]};
            int tmp_pose_ang_r_int = new BigInteger(tmp_pose_angle_r).intValue();
            details = details + "pose_ang=\"(" + tmp_pose_ang_y_int + "," + tmp_pose_ang_p_int + "," + tmp_pose_ang_r_int + "\"),";
            byte[] tmp_pose_unc_y = new byte[]{input[j++], input[j++], input[j++]};
            int tmp_pose_unc_y_int = new BigInteger(tmp_pose_unc_y).intValue();
            byte[] tmp_pose_unc_p = new byte[]{input[j++], input[j++], input[j++]};
            int tmp_pose_unc_p_int = new BigInteger(tmp_pose_unc_p).intValue();
            byte[] tmp_pose_unc_r = new byte[]{input[j++], input[j++], input[j++]};
            int tmp_pose_unc_r_int = new BigInteger(tmp_pose_unc_r).intValue();
            details = details + "pose_unc=\"(" + tmp_pose_unc_y_int + "," + tmp_pose_unc_p_int + "," + tmp_pose_unc_r_int + "\"),";
            if (tmp_face_pts_int < 1) {
                details = details + "no_facial_pts,";
            } else {
                details = details + "facial_pts:";
                for (int k = 0; k < tmp_face_pts_int; ++k) {
                    details = details + "(fac_pt#" + (k + 1) + ":";
                    byte[] tmp_type = new byte[]{input[j++]};
                    int tmp_type_int = new BigInteger(tmp_type).intValue();
                    details = details + "type=\"" + tmp_type_int + "\",";
                    byte[] tmp_code = new byte[]{input[j++]};
                    int tmp_code_int = new BigInteger(tmp_code).intValue();
                    details = details + "code=\"" + tmp_code_int + "\",";
                    byte[] tmp_hor_poz = new byte[]{input[j++], input[j++]};
                    int tmp_hor_poz_int = new BigInteger(tmp_hor_poz).intValue();
                    details = details + "hor_poz=\"" + tmp_hor_poz_int + "\",";
                    byte[] tmp_ver_poz = new byte[]{input[j++], input[j++]};
                    int tmp_ver_poz_int = new BigInteger(tmp_ver_poz).intValue();
                    details = details + "ver_poz=\"" + tmp_ver_poz_int + "\",";
                    details = details + "reserved=\"" + input[j++] + input[j++] + "\")";
                }
            }
            byte[] tmp_img_type = new byte[]{input[j++]};
            int tmp_img_type_int = new BigInteger(tmp_img_type).intValue();
            details = details + "img_type=\"" + tmp_img_type_int + "\",";
            byte[] tmp_data_type = new byte[]{input[j++]};
            int tmp_data_type_int = new BigInteger(tmp_data_type).intValue();
            details = details + "data_type=\"" + tmp_data_type_int + "\",";
            byte[] tmp_width = new byte[]{input[j++], input[j++]};
            int tmp_width_int = new BigInteger(tmp_width).intValue();
            details = details + "width=\"" + tmp_width_int + "\",";
            byte[] tmp_height = new byte[]{input[j++], input[j++]};
            int tmp_height_int = new BigInteger(tmp_height).intValue();
            details = details + "height=\"" + tmp_height_int + "\",";
            byte[] tmp_col_spce = new byte[]{input[j++]};
            int tmp_col_spce_int = new BigInteger(tmp_col_spce).intValue();
            details = details + "col_spce=\"" + tmp_col_spce_int + "\",";
            byte[] tmp_src_type = new byte[]{input[j++]};
            int tmp_src_type_int = new BigInteger(tmp_src_type).intValue();
            details = details + "src_type=\"" + tmp_src_type_int + "\",";
            byte[] tmp_dev_type = new byte[]{input[j++], input[j++]};
            int tmp_dev_type_int = new BigInteger(tmp_dev_type).intValue();
            details = details + "dev_type=\"" + tmp_dev_type_int + "\",";
            details = details + "qual=\"" + input[j++] + input[j++] + "\")";
            j += image_data_size;
        }
        details = details + "}";
        return details;
    }

    public static boolean checkHeader(byte[] input) {
        byte[] all_length;
        int all_length_int;
        boolean output = true;
        if (input == null) {
            LOG.error((Object)"No data submitted!");
            output = false;
        }
        if (input[0] != 70 || input[1] != 65 || input[2] != 67 || input[3] != 0) {
            LOG.error((Object)"Not a facial record!");
            output = false;
        }
        if ((all_length_int = new BigInteger(all_length = new byte[]{input[8], input[9], input[10], input[11]}).intValue()) != input.length) {
            LOG.error((Object)("Referential Integrity: Record Length Mismatch: Coded(" + all_length_int + ") vs Real(" + input.length + ")"));
            output = false;
        }
        return output;
    }

    public static Vector<ImageStruct> getImagesFromPackage(byte[] input) throws Exception {
        return FacialISO.getImagesFromPackage(input, true);
    }

    public static Vector<ImageStruct> getImagesFromPackage(byte[] input, boolean strict) throws Exception {
        if (input == null) {
            throw new Exception("No data passed to parse!");
        }
        LOG.info((Object)("FaceHeader:\n" + FacialISO.inspectHeader(input)));
        Vector<ImageStruct> output = new Vector<ImageStruct>();
        if (input[0] != 70 || input[1] != 65 || input[2] != 67 || input[3] != 0) {
            throw new Exception("Not a facial record!");
        }
        byte[] all_length = new byte[]{input[8], input[9], input[10], input[11]};
        int all_length_int = new BigInteger(all_length).intValue();
        LOG.info((Object)("Code Full Record Length: " + all_length_int + " vs Real: " + input.length));
        if (strict && all_length_int != input.length) {
            throw new Exception("Referential Integrity: record length mismatch.");
        }
        byte[] face_count = new byte[]{input[12], input[13]};
        int face_count_int = new BigInteger(face_count).intValue();
        int j = 14;
        for (int i = 0; i < face_count_int; ++i) {
            byte[] tmp_image_size = new byte[]{input[j++], input[j++], input[j++], input[j++]};
            int tmp_image_size_int = new BigInteger(tmp_image_size).intValue();
            LOG.info((Object)("Image Record Size: " + tmp_image_size_int));
            byte[] tmp_image = new byte[tmp_image_size_int];
            byte[] tmp_face_pts = new byte[]{input[j++], input[j++]};
            int tmp_face_pts_int = new BigInteger(tmp_face_pts).intValue();
            LOG.info((Object)("Facial Points: " + tmp_face_pts_int));
            int image_data_size = tmp_image_size_int - 32 - 8 * tmp_face_pts_int;
            j += 14;
            j += 8 * tmp_face_pts_int;
            byte[] byArray = new byte[1];
            int n = ++j;
            byArray[0] = input[n];
            byte[] img_type = byArray;
            int img_type_int = new BigInteger(img_type).intValue();
            LOG.info((Object)("Face file type code: " + img_type_int));
            int img_type_code = CBEFFFace.encodeFileType(img_type_int);
            byte[] byArray2 = new byte[2];
            int n2 = ++j;
            byArray2[0] = input[n2];
            int n3 = ++j;
            byArray2[1] = input[n3];
            byte[] tmp_width = byArray2;
            int tmp_width_int = new BigInteger(tmp_width).intValue();
            byte[] byArray3 = new byte[2];
            int n4 = ++j;
            byArray3[0] = input[n4];
            int n5 = ++j;
            ++j;
            byArray3[1] = input[n5];
            byte[] tmp_height = byArray3;
            int tmp_height_int = new BigInteger(tmp_height).intValue();
            j += 6;
            int y = 0;
            while (y < image_data_size) {
                tmp_image[y] = input[j];
                ++y;
                ++j;
            }
            ImageStruct tmp_is = new ImageStruct(tmp_image, img_type_code, tmp_width_int, tmp_height_int);
            output.add(tmp_is);
        }
        return output;
    }

    protected static byte[] getImageHeader(int image_size, int file_type, int width, int height) {
        byte[] output = new byte[32];
        byte[] len = Utility.intToByteArray(image_size + 32, 4);
        output[0] = len[0];
        output[1] = len[1];
        output[2] = len[2];
        output[3] = len[3];
        output[4] = 0;
        output[5] = 0;
        output[6] = 0;
        output[7] = 0;
        output[8] = 0;
        output[9] = 0;
        output[10] = 0;
        output[11] = 0;
        output[12] = 0;
        output[13] = 0;
        output[14] = 0;
        output[15] = 0;
        output[16] = 0;
        output[17] = 0;
        output[18] = 0;
        output[19] = 0;
        output[20] = 0;
        output[21] = Utility.smallIntToByte(file_type);
        byte[] wid = Utility.intToByteArray(width, 2);
        output[22] = wid[0];
        output[23] = wid[1];
        byte[] het = Utility.intToByteArray(height, 2);
        output[24] = het[0];
        output[25] = het[1];
        output[26] = 0;
        output[27] = 0;
        output[28] = 0;
        output[29] = 0;
        output[30] = 0;
        output[31] = 0;
        return output;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Invalid Arguments: Must specify a file to parse w/ optional second argument file extension!");
            System.exit(-1);
        }
        String type = new String("jp2");
        if (args.length > 1) {
            type = new String(args[1]);
        }
        byte[] image = null;
        Vector<ImageStruct> images = null;
        File input = null;
        try {
            input = new File(args[0]);
            image = Utility.getImageByteArray(input);
        }
        catch (Exception e) {
            System.out.println("Reading image file failed!");
            e.printStackTrace();
            System.exit(-2);
        }
        try {
            images = FacialISO.getImagesFromPackage(image);
        }
        catch (Exception e) {
            System.out.println("Parsing image stream failed!");
            e.printStackTrace();
            System.exit(-3);
        }
        try {
            new File("output").mkdirs();
            for (int i = 0; i < images.size(); ++i) {
                byte[] tmp_img = images.elementAt(i).getImage();
                Utility.writeBytesToFile(tmp_img, "output", input.getName() + "." + (i + 1) + ".parsed." + type);
            }
        }
        catch (Exception e) {
            System.out.println("Writing parsed image failed!");
            e.printStackTrace();
            System.exit(-4);
        }
    }
}

