/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFFFinger;
import com.identix.uidai.cbeff.ImageStruct;
import com.identix.util.Utility;
import java.io.File;
import java.math.BigInteger;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FingerISO {
    public static final int HEADER_SIZE = 32;
    public static final int IMAGE_HEADER_SIZE = 14;
    private static final Logger LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.FingerISO");

    public static byte[] packageImage(byte[] image, int file_type, int position, int width, int height) {
        byte[] output = new byte[image.length + 32 + 14];
        byte[] head = FingerISO.getHeader(image.length, file_type, width, height);
        byte[] imghead = FingerISO.getImageHeader(image.length, position, width, height);
        int i = 0;
        int j = 0;
        while (j < head.length) {
            output[i] = head[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < imghead.length) {
            output[i] = imghead[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < image.length) {
            output[i] = image[j];
            ++j;
            ++i;
        }
        return output;
    }

    public static String inspectHeader(byte[] input) throws Exception {
        if (input == null) {
            throw new Exception("No data passed to parse!");
        }
        String details = new String("");
        details = details + "{actual_size=\"" + input.length + "\",";
        details = details + "format=\"" + input[0] + input[1] + input[2] + input[3] + "\",";
        details = details + "version=\"" + input[4] + input[5] + input[6] + input[7] + "\",";
        byte[] all_length = new byte[]{input[8], input[9], input[10], input[11], input[12], input[13]};
        long all_length_long = new BigInteger(all_length).longValue();
        details = details + "length=\"" + all_length_long + "\",";
        details = details + "dev_id=\"" + input[14] + input[15] + "\",";
        details = details + "img_acq_lev=\"" + input[16] + input[17] + "\",";
        byte[] finger_count = new byte[]{input[18]};
        int finger_count_int = new BigInteger(finger_count).intValue();
        details = details + "finger_ct=\"" + finger_count_int + "\",";
        byte[] scale_units = new byte[]{input[19]};
        int scale_units_int = new BigInteger(scale_units).intValue();
        details = details + "scale_units=\"" + scale_units_int + "\",";
        byte[] h_scan_rez = new byte[]{input[20], input[21]};
        int h_scan_rez_int = new BigInteger(h_scan_rez).intValue();
        details = details + "h_scan_rez=\"" + h_scan_rez_int + "\",";
        byte[] v_scane_rez = new byte[]{input[22], input[23]};
        int v_scane_rez_int = new BigInteger(v_scane_rez).intValue();
        details = details + "v_scan_rez=\"" + v_scane_rez_int + "\",";
        byte[] h_img_rez = new byte[]{input[24], input[25]};
        int h_img_rez_int = new BigInteger(h_img_rez).intValue();
        details = details + "h_img_rez=\"" + h_img_rez_int + "\",";
        byte[] v_img_rez = new byte[]{input[26], input[27]};
        int v_img_rez_int = new BigInteger(v_img_rez).intValue();
        details = details + "v_img_rez=\"" + v_img_rez_int + "\",";
        byte[] pix_depth = new byte[]{input[28]};
        int pix_depth_int = new BigInteger(pix_depth).intValue();
        details = details + "pix_depth=\"" + pix_depth_int + "\",";
        byte[] img_type = new byte[]{input[29]};
        int img_type_int = new BigInteger(img_type).intValue();
        details = details + "img_type=\"" + img_type_int + "\",";
        details = details + "reserved=\"" + input[30] + input[31] + "\"::";
        int j = 32;
        for (int i = 0; i < finger_count_int; ++i) {
            details = details + "(Finger#" + (i + 1) + ":";
            byte[] tmp_image_size = new byte[]{input[j++], input[j++], input[j++], input[j++]};
            int tmp_image_size_int = new BigInteger(tmp_image_size).intValue();
            details = details + "img_size=\"" + tmp_image_size_int + "\",";
            int image_data_size = tmp_image_size_int - 14;
            byte[] tmp_pos = new byte[]{input[j++]};
            int tmp_pos_int = new BigInteger(tmp_pos).intValue();
            details = details + "pos_code=\"" + tmp_pos_int + "\",";
            byte[] tmp_view_ct = new byte[]{input[j++]};
            int tmp_view_ct_int = new BigInteger(tmp_view_ct).intValue();
            details = details + "view_ct=\"" + tmp_view_ct_int + "\",";
            byte[] tmp_view_no = new byte[]{input[j++]};
            int tmp_view_no_int = new BigInteger(tmp_view_no).intValue();
            details = details + "view_no=\"" + tmp_view_no_int + "\",";
            byte[] tmp_img_qual = new byte[]{input[j++]};
            int tmp_img_qual_int = new BigInteger(tmp_img_qual).intValue();
            details = details + "img_qual=\"" + tmp_img_qual_int + "\",";
            byte[] tmp_imp_type = new byte[]{input[j++]};
            int tmp_imp_type_int = new BigInteger(tmp_imp_type).intValue();
            details = details + "imp_type=\"" + tmp_imp_type_int + "\",";
            byte[] tmp_width = new byte[]{input[j++], input[j++]};
            int tmp_width_int = new BigInteger(tmp_width).intValue();
            details = details + "width=\"" + tmp_width_int + "\",";
            byte[] tmp_height = new byte[]{input[j++], input[j++]};
            int tmp_height_int = new BigInteger(tmp_height).intValue();
            details = details + "height=\"" + tmp_height_int + "\",";
            details = details + "reserved=\"" + input[j++] + "\")";
            j += image_data_size;
        }
        details = details + "}";
        return details;
    }

    public static boolean checkHeader(byte[] input) {
        byte[] all_length;
        long all_length_long;
        boolean output = true;
        if (input == null) {
            LOG.error((Object)"No data submitted!");
            output = false;
        }
        if (input[0] != 70 || input[1] != 73 || input[2] != 82 || input[3] != 0) {
            LOG.error((Object)"Not a finger record!");
            output = false;
        }
        if ((all_length_long = new BigInteger(all_length = new byte[]{input[8], input[9], input[10], input[11], input[12], input[13]}).longValue()) != (long)input.length) {
            LOG.error((Object)("Referential Integrity: Record Length Mismatch: Coded(" + all_length_long + ") vs Real(" + input.length + ")"));
            output = false;
        }
        return output;
    }

    public static Vector<ImageStruct> getImagesFromPackage(byte[] input) throws Exception {
        return FingerISO.getImagesFromPackage(input, true);
    }

    public static Vector<ImageStruct> getImagesFromPackage(byte[] input, boolean strict) throws Exception {
        if (input == null) {
            throw new Exception("No data passed to parse!");
        }
        LOG.info((Object)("FingerHeader:\n" + FingerISO.inspectHeader(input)));
        Vector<ImageStruct> output = new Vector<ImageStruct>();
        if (input[0] != 70 || input[1] != 73 || input[2] != 82 || input[3] != 0) {
            throw new Exception("Not a finger record!");
        }
        byte[] all_length = new byte[]{input[8], input[9], input[10], input[11], input[12], input[13]};
        long all_length_long = new BigInteger(all_length).longValue();
        LOG.info((Object)("Code Full Record Length: " + all_length_long + " vs Real: " + input.length));
        if (strict && all_length_long != (long)input.length) {
            throw new Exception("Referential Integrity: record length mismatch.");
        }
        byte[] finger_count = new byte[]{input[18]};
        int finger_count_int = new BigInteger(finger_count).intValue();
        byte[] img_type = new byte[]{input[29]};
        int img_type_int = new BigInteger(img_type).intValue();
        LOG.info((Object)("Finger file type code: " + img_type_int));
        int img_fmt_code = CBEFFFinger.encodeFileType(img_type_int);
        int j = 32;
        for (int i = 0; i < finger_count_int; ++i) {
            byte[] tmp_image_size = new byte[]{input[j++], input[j++], input[j++], input[j++]};
            int tmp_image_size_int = new BigInteger(tmp_image_size).intValue();
            LOG.info((Object)("Image Size: " + tmp_image_size_int));
            int image_data_size = tmp_image_size_int - 14;
            byte[] tmp_image = new byte[tmp_image_size_int];
            byte[] tmp_pos = new byte[]{input[j++]};
            int tmp_pos_int = new BigInteger(tmp_pos).intValue();
            LOG.info((Object)("Finger position code: " + tmp_pos_int));
            byte[] tmp_view_ct = new byte[]{input[j++]};
            int tmp_view_ct_int = new BigInteger(tmp_view_ct).intValue();
            byte[] tmp_view_no = new byte[]{input[j++]};
            int tmp_view_no_int = new BigInteger(tmp_view_no).intValue();
            byte[] byArray = new byte[1];
            int n = ++j;
            byArray[0] = input[n];
            byte[] tmp_imp_type = byArray;
            int tmp_imp_type_int = new BigInteger(tmp_imp_type).intValue();
            LOG.info((Object)("Finger impression type code: " + tmp_imp_type_int));
            byte[] byArray2 = new byte[2];
            int n2 = ++j;
            byArray2[0] = input[n2];
            int n3 = ++j;
            byArray2[1] = input[n3];
            byte[] tmp_width = byArray2;
            int tmp_width_int = new BigInteger(tmp_width).intValue();
            byte[] byArray3 = new byte[2];
            int n4 = ++j;
            byArray3[0] = input[n4];
            int n5 = ++j;
            ++j;
            byArray3[1] = input[n5];
            byte[] tmp_height = byArray3;
            int tmp_height_int = new BigInteger(tmp_height).intValue();
            ++j;
            int y = 0;
            while (y < image_data_size) {
                tmp_image[y] = input[j];
                ++y;
                ++j;
            }
            ImageStruct tmp_is = new ImageStruct(tmp_image, img_fmt_code, tmp_width_int, tmp_height_int, tmp_pos_int, tmp_view_ct_int, tmp_view_no_int, tmp_imp_type_int);
            output.add(tmp_is);
        }
        return output;
    }

    public static byte[] getHeader(int image_size, int img_fmt, int width, int height) {
        byte[] output = new byte[32];
        output[0] = 70;
        output[1] = 73;
        output[2] = 82;
        output[3] = 0;
        output[4] = 48;
        output[5] = 49;
        output[6] = 48;
        output[7] = 0;
        byte[] len = Utility.longToByteArray(image_size + 32 + 14, 6);
        output[8] = len[0];
        output[9] = len[1];
        output[10] = len[2];
        output[11] = len[3];
        output[12] = len[4];
        output[13] = len[5];
        output[14] = 0;
        output[15] = 0;
        output[16] = 0;
        output[17] = 0;
        output[18] = Utility.smallIntToByte(1);
        output[19] = 0;
        output[20] = 0;
        output[21] = 0;
        output[22] = 0;
        output[23] = 0;
        output[24] = 0;
        output[25] = 0;
        output[26] = 0;
        output[27] = 0;
        output[28] = 0;
        output[29] = Utility.smallIntToByte(img_fmt);
        output[30] = 0;
        output[31] = 0;
        return output;
    }

    public static byte[] getImageHeader(int image_length, int position, int width, int height) {
        byte[] output = new byte[14];
        byte[] len = Utility.intToByteArray(image_length + 14, 4);
        output[0] = len[0];
        output[1] = len[1];
        output[2] = len[2];
        output[3] = len[3];
        output[4] = Utility.smallIntToByte(position);
        output[5] = 0;
        output[6] = 0;
        output[7] = 0;
        output[8] = 0;
        byte[] tmp_wid = Utility.intToByteArray(width, 2);
        output[9] = tmp_wid[0];
        output[10] = tmp_wid[1];
        byte[] tmp_het = Utility.intToByteArray(height, 2);
        output[11] = tmp_het[0];
        output[12] = tmp_het[1];
        output[13] = 0;
        return output;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Invalid Arguments: Must specify a file to parse w/ optional second argument file extension!");
            System.exit(-1);
        }
        String type = new String("jp2");
        if (args.length > 1) {
            type = new String(args[1]);
        }
        byte[] image = null;
        Vector<ImageStruct> images = null;
        File input = null;
        try {
            input = new File(args[0]);
            image = Utility.getImageByteArray(input);
        }
        catch (Exception e) {
            System.out.println("Reading image file failed!");
            e.printStackTrace();
            System.exit(-2);
        }
        try {
            images = FingerISO.getImagesFromPackage(image);
        }
        catch (Exception e) {
            System.out.println("Parsing image stream failed!");
            e.printStackTrace();
            System.exit(-3);
        }
        try {
            new File("output").mkdirs();
            for (int i = 0; i < images.size(); ++i) {
                byte[] tmp_img = images.elementAt(i).getImage();
                Utility.writeBytesToFile(tmp_img, "output", input.getName() + "." + (i + 1) + ".parsed." + type);
            }
        }
        catch (Exception e) {
            System.out.println("Writing parsed image failed!");
            e.printStackTrace();
            System.exit(-4);
        }
    }
}

