/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

public class ImageStruct {
    public static final int JPEG_2000 = 0;
    public static final int JPEG_2000_MONO = 1;
    public static final int JPEG = 2;
    public static final int JPEG_MONO = 3;
    public static final int JPEG_LS = 4;
    public static final int JPEG_LS_MONO = 5;
    public static final int WSQ = 6;
    public static final int PNG = 7;
    public static final int RAW = 8;
    public static final int RAW_MONO = 9;
    public static final int RAW_BIT_PACK = 10;
    protected byte[] _image = null;
    protected int _width = 0;
    protected int _height = 0;
    protected int _image_type = 0;
    protected int _position = 0;
    protected int _view_ct = 0;
    protected int _view_no = 0;
    protected int _imp_type = 0;

    public ImageStruct(byte[] input) {
        if (input != null) {
            this._image = (byte[])input.clone();
        }
    }

    public ImageStruct(byte[] input, int image_type) {
        this(input);
        this.setImageType(image_type);
    }

    public ImageStruct(byte[] input, int image_type, int width, int height) {
        this(input, image_type);
        this._width = width;
        this._height = height;
    }

    public ImageStruct(byte[] input, int image_type, int width, int height, int position, int view_ct, int view_no) {
        this(input, image_type, width, height);
        this._position = position;
        this._view_ct = view_ct;
        this._view_no = view_no;
    }

    public ImageStruct(byte[] input, int image_type, int width, int height, int position, int view_ct, int view_no, int imp_type) {
        this(input, image_type, width, height, position, view_ct, view_no);
        this._imp_type = imp_type;
    }

    private void setImageType(int input) {
        this._image_type = input == 0 || input == 1 || input == 4 || input == 5 || input == 2 || input == 3 || input == 6 || input == 7 || input == 8 || input == 9 || input == 10 ? input : 0;
    }

    public static String translateImageType(int input) {
        switch (input) {
            case 2: 
            case 3: {
                return "jpg";
            }
            case 4: 
            case 5: {
                return "jls";
            }
            case 6: {
                return "wsq";
            }
            case 7: {
                return "png";
            }
            case 8: 
            case 9: {
                return "raw";
            }
            case 10: {
                return "bpi";
            }
        }
        return "jp2";
    }

    public static int translateFileExtension(String input) {
        if (input.equalsIgnoreCase("jp2")) {
            return 0;
        }
        if (input.equalsIgnoreCase("jpg")) {
            return 2;
        }
        if (input.equalsIgnoreCase("jls")) {
            return 4;
        }
        if (input.equalsIgnoreCase("wsq")) {
            return 6;
        }
        if (input.equalsIgnoreCase("png")) {
            return 7;
        }
        if (input.equalsIgnoreCase("raw")) {
            return 8;
        }
        if (input.equalsIgnoreCase("bpi")) {
            return 10;
        }
        return 0;
    }

    public byte[] getImage() {
        return (byte[])this._image.clone();
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getImageType() {
        return this._image_type;
    }

    public int getPosition() {
        return this._position;
    }

    public int getViewCount() {
        return this._view_ct;
    }

    public int getViewNumber() {
        return this._view_no;
    }

    public int getImpType() {
        return this._imp_type;
    }
}

