/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFFIris;
import com.identix.uidai.cbeff.IrisImageStruct;
import com.identix.util.Utility;
import java.io.File;
import java.math.BigInteger;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IrisISO {
    public static final int HEADER_SIZE = 45;
    public static final int SUB_HEADER_SIZE = 3;
    public static final int IMAGE_HEADER_SIZE = 11;
    public static final int UNK = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int ORIENTATION_UNDEF = 0;
    public static final int ORIENTATION_BASE = 1;
    public static final int ORIENTATION_FLIPPED = 2;
    public static final int SCAN_TYPE_CORRECTED = 0;
    public static final int SCAN_TYPE_PROGRESSIVE = 1;
    public static final int SCAN_TYPE_INTERLACE_FRAME = 2;
    public static final int SCAN_TYPE_INTERLACE_FIELD = 3;
    public static final int IROCC_UNDEF = 0;
    public static final int IROCC_PROCESSED = 1;
    public static final int IROCC_ZEROFILL = 0;
    public static final int IROCC_UNITFILL = 1;
    public static final int IRBNDY_UNDEF = 0;
    public static final int IRBNDY_PROCESSED = 1;
    private static final Logger LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.IrisISO");

    public static byte[] packageImage(byte[] image, int file_type, int eye_pos, int width, int height) {
        byte[] output = new byte[image.length + 45 + 3 + 11];
        byte[] head = IrisISO.getHeader(image.length, file_type, width, height);
        byte[] subhead = IrisISO.getImageSubTypeHeader(eye_pos);
        byte[] imghead = IrisISO.getImageHeader(image.length);
        int i = 0;
        int j = 0;
        while (j < head.length) {
            output[i] = head[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < subhead.length) {
            output[i] = subhead[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < imghead.length) {
            output[i] = imghead[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < image.length) {
            output[i] = image[j];
            ++j;
            ++i;
        }
        return output;
    }

    public static String inspectHeader(byte[] input) throws Exception {
        if (input == null) {
            throw new Exception("No data passed to parse!");
        }
        String details = new String("");
        details = details + "{actual_size=\"" + input.length + "\",";
        details = details + "format=\"" + input[0] + input[1] + input[2] + input[3] + "\",";
        details = details + "version=\"" + input[4] + input[5] + input[6] + input[7] + "\",";
        byte[] all_length = new byte[]{input[8], input[9], input[10], input[11]};
        int all_length_int = new BigInteger(all_length).intValue();
        details = details + "length=\"" + all_length_int + "\",";
        byte[] dev_id = new byte[]{input[12], input[13]};
        int dev_id_int = new BigInteger(dev_id).intValue();
        details = details + "dev_id=\"" + dev_id_int + "\",";
        byte[] iris_count = new byte[]{input[14]};
        int iris_count_int = new BigInteger(iris_count).intValue();
        details = details + "iris_ct=\"" + iris_count_int + "\",";
        byte[] header_size = new byte[]{input[15], input[16]};
        int header_size_int = new BigInteger(header_size).intValue();
        details = details + "head_sz=\"" + header_size_int + "\",";
        byte[] eye_props = new byte[]{input[17], input[18]};
        int[] tmp_props = Utility.getBitArray(eye_props);
        details = details + "eye_props=\"" + Utility.intArrayToString(tmp_props) + "\":(";
        int tmp_horizontal_orientation = Utility.getInt(tmp_props[14], tmp_props[15]);
        int tmp_vertical_orientation = Utility.getInt(tmp_props[12], tmp_props[13]);
        int tmp_scan_type = Utility.getInt(tmp_props[10], tmp_props[11]);
        int tmp_occlusions = Utility.getInt(tmp_props[9]);
        int tmp_occlusion_filling = Utility.getInt(tmp_props[8]);
        int tmp_boundary_extraction = Utility.getInt(tmp_props[7]);
        details = details + "horient=\"" + tmp_horizontal_orientation + "\",";
        details = details + "vorient=\"" + tmp_vertical_orientation + "\",";
        details = details + "scantype=\"" + tmp_scan_type + "\",";
        details = details + "occl=\"" + tmp_occlusions + "\",";
        details = details + "occl_fill=\"" + tmp_occlusion_filling + "\",";
        details = details + "bound_extr=\"" + tmp_boundary_extraction + "\"),";
        byte[] tmp_diameter = new byte[]{input[19], input[20]};
        int tmp_diameter_int = new BigInteger(tmp_diameter).intValue();
        details = details + "diameter=\"" + tmp_diameter_int + "\",";
        byte[] img_fmt = new byte[]{input[21], input[22]};
        int img_fmt_int = new BigInteger(img_fmt).intValue();
        details = details + "img_fmt=\"" + img_fmt_int + "\",";
        byte[] width = new byte[]{input[23], input[24]};
        int width_int = new BigInteger(width).intValue();
        details = details + "img_width=\"" + width_int + "\",";
        byte[] height = new byte[]{input[25], input[26]};
        int height_int = new BigInteger(height).intValue();
        details = details + "img_height=\"" + height_int + "\",";
        details = details + "int_depth=\"" + input[27] + "\",";
        details = details + "img_trans=\"" + input[28] + "\",";
        details = details + "dev_unq_id=\"" + input[29] + input[30] + input[31] + input[32] + input[33] + input[34] + input[35] + input[36] + input[37] + input[38] + input[39] + input[40] + input[41] + input[42] + input[43] + input[44] + "\",";
        int i = 45;
        for (int j = 0; j < iris_count_int; ++j) {
            details = details + "(Iris#" + (j + 1) + ":";
            byte[] eye_type = new byte[]{input[i++]};
            int eye_type_int = new BigInteger(eye_type).intValue();
            details = details + "eye_type=\"" + eye_type_int + "\",";
            byte[] img_ct = new byte[]{input[i++], input[i++]};
            int img_ct_int = new BigInteger(img_ct).intValue();
            details = details + "img_ct=\"" + img_ct_int + "\",";
            for (int k = 0; k < img_ct_int; ++k) {
                details = details + "[img#" + (k + 1) + ":";
                byte[] img_no = new byte[]{input[i++], input[i++]};
                int img_no_int = new BigInteger(img_no).intValue();
                details = details + "img_no=\"" + img_no_int + "\",";
                details = details + "qual=\"" + input[i++] + "\",";
                byte[] rot_ang = new byte[]{input[i++], input[i++]};
                int rot_ang_int = new BigInteger(rot_ang).intValue();
                details = details + "rot_ang=\"" + rot_ang_int + "\",";
                byte[] rot_unc = new byte[]{input[i++], input[i++]};
                int rot_unc_int = new BigInteger(rot_unc).intValue();
                details = details + "rot_unc=\"" + rot_unc_int + "\",";
                byte[] img_sz = new byte[]{input[i++], input[i++], input[i++], input[i++]};
                int img_sz_int = new BigInteger(img_sz).intValue();
                details = details + "img_len=\"" + img_sz_int + "\"]";
                i += img_sz_int;
            }
            details = details + ")";
        }
        details = details + "}";
        return details;
    }

    public static boolean checkHeader(byte[] input) {
        byte[] header_size;
        int header_size_int;
        byte[] all_length;
        int all_length_int;
        boolean output = true;
        if (input == null) {
            LOG.error((Object)"No data submitted!");
            output = false;
        }
        if (input[0] != 73 || input[1] != 73 || input[2] != 82 || input[3] != 0) {
            LOG.error((Object)"Not an iris record!");
            output = false;
        }
        if ((all_length_int = new BigInteger(all_length = new byte[]{input[8], input[9], input[10], input[11]}).intValue()) != input.length) {
            LOG.error((Object)("Referential Integrity: Record Length Mismatch: Coded(" + all_length_int + ") vs Real(" + input.length + ")"));
            output = false;
        }
        if ((header_size_int = new BigInteger(header_size = new byte[]{input[15], input[16]}).intValue()) != 45) {
            LOG.error((Object)("Referential Integrity: Header Length Incompatible: Coded(" + header_size_int + ") vs Spec(" + 45 + ")"));
            output = false;
        }
        return output;
    }

    public static Vector<IrisImageStruct> getImagesFromPackage(byte[] input) throws Exception {
        return IrisISO.getImagesFromPackage(input, true);
    }

    public static Vector<IrisImageStruct> getImagesFromPackage(byte[] input, boolean strict) throws Exception {
        if (input == null) {
            throw new Exception("No data passed to parse!");
        }
        LOG.info((Object)("IrisHeader:\n" + IrisISO.inspectHeader(input)));
        Vector<IrisImageStruct> output = new Vector<IrisImageStruct>();
        if (input[0] != 73 || input[1] != 73 || input[2] != 82 || input[3] != 0) {
            throw new Exception("Not an iris record!");
        }
        byte[] all_length = new byte[]{input[8], input[9], input[10], input[11]};
        int all_length_int = new BigInteger(all_length).intValue();
        LOG.info((Object)("Code Full Record Length: " + all_length_int + " vs Real: " + input.length));
        if (strict && all_length_int != input.length) {
            throw new Exception("Referential Integrity: record length mismatch.");
        }
        byte[] eye_count = new byte[]{input[14]};
        int eye_count_int = new BigInteger(eye_count).intValue();
        byte[] header_size = new byte[]{input[15], input[16]};
        int header_size_int = new BigInteger(header_size).intValue();
        if (strict && header_size_int != 45) {
            throw new Exception("Referential Integrity: Specified header length incompatible.");
        }
        byte[] eye_props = new byte[]{input[17], input[18]};
        int[] tmp_props = Utility.getBitArray(eye_props);
        int tmp_horizontal_orientation = Utility.getInt(tmp_props[14], tmp_props[15]);
        int tmp_vertical_orientation = Utility.getInt(tmp_props[12], tmp_props[13]);
        int tmp_scan_type = Utility.getInt(tmp_props[10], tmp_props[11]);
        int tmp_occlusions = Utility.getInt(tmp_props[9]);
        int tmp_occlusion_filling = Utility.getInt(tmp_props[8]);
        int tmp_boundary_extraction = Utility.getInt(tmp_props[7]);
        byte[] img_fmt = new byte[]{input[21], input[22]};
        int img_type_int = new BigInteger(img_fmt).intValue();
        LOG.info((Object)("Iris file type code: " + img_type_int));
        int img_fmt_code = CBEFFIris.encodeFileType(img_type_int);
        byte[] width = new byte[]{input[23], input[24]};
        int width_int = new BigInteger(width).intValue();
        byte[] height = new byte[]{input[25], input[26]};
        int height_int = new BigInteger(height).intValue();
        int i = 45;
        for (int j = 0; j < eye_count_int; ++j) {
            byte[] eye_type = new byte[]{input[i++]};
            int eye_type_int = new BigInteger(eye_type).intValue();
            byte[] img_ct = new byte[]{input[i++], input[i++]};
            int img_ct_int = new BigInteger(img_ct).intValue();
            for (int k = 0; k < img_ct_int; ++k) {
                i += 7;
                byte[] img_sz = new byte[]{input[i++], input[i++], input[i++], input[i++]};
                int img_sz_int = new BigInteger(img_sz).intValue();
                LOG.info((Object)("Image Size: " + img_sz_int));
                byte[] tmp_image = new byte[img_sz_int];
                int l = 0;
                while (l < img_sz_int) {
                    tmp_image[l] = input[i];
                    ++l;
                    ++i;
                }
                IrisImageStruct tmp_is = new IrisImageStruct(tmp_image, img_fmt_code, width_int, height_int, eye_type_int, img_ct_int, k + 1, tmp_horizontal_orientation, tmp_vertical_orientation, tmp_scan_type, tmp_occlusions, tmp_occlusion_filling, tmp_boundary_extraction);
                output.add(tmp_is);
            }
        }
        return output;
    }

    public static byte[] getHeader(int image_size, int img_fmt, int width, int height) {
        byte[] output = new byte[45];
        output[0] = 73;
        output[1] = 73;
        output[2] = 82;
        output[3] = 0;
        output[4] = 48;
        output[5] = 49;
        output[6] = 48;
        output[7] = 0;
        byte[] len = Utility.intToByteArray(image_size + 45 + 3 + 11, 4);
        output[8] = len[0];
        output[9] = len[1];
        output[10] = len[2];
        output[11] = len[3];
        output[12] = 0;
        output[13] = 0;
        output[14] = Utility.smallIntToByte(1);
        byte[] head_sz = Utility.intToByteArray(45, 2);
        output[15] = head_sz[0];
        output[16] = head_sz[1];
        output[17] = 0;
        output[18] = 0;
        output[19] = 0;
        output[20] = 0;
        byte[] img_tp = Utility.intToByteArray(img_fmt, 2);
        output[21] = img_tp[0];
        output[22] = img_tp[1];
        byte[] tmp_wid = Utility.intToByteArray(width, 2);
        output[23] = tmp_wid[0];
        output[24] = tmp_wid[1];
        byte[] tmp_het = Utility.intToByteArray(height, 2);
        output[25] = tmp_het[0];
        output[26] = tmp_het[1];
        for (int i = 27; i < 45; ++i) {
            output[i] = 0;
        }
        return output;
    }

    public static byte[] getImageSubTypeHeader(int eye_pos) {
        byte[] output = new byte[3];
        output[0] = Utility.smallIntToByte(eye_pos);
        byte[] len = Utility.intToByteArray(1, 2);
        output[1] = len[0];
        output[2] = len[1];
        return output;
    }

    public static byte[] getImageHeader(int image_length) {
        byte[] output = new byte[11];
        output[0] = 0;
        output[1] = 0;
        output[2] = 0;
        output[3] = 0;
        output[4] = 0;
        output[5] = 0;
        output[6] = 0;
        byte[] len = Utility.intToByteArray(image_length, 4);
        output[7] = len[0];
        output[8] = len[1];
        output[9] = len[2];
        output[10] = len[3];
        return output;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Invalid Arguments: Must specify a file to parse w/ optional second argument file extension!");
            System.exit(-1);
        }
        String type = new String("jp2");
        if (args.length > 1) {
            type = new String(args[1]);
        }
        byte[] image = null;
        Vector<IrisImageStruct> images = null;
        File input = null;
        try {
            input = new File(args[0]);
            image = Utility.getImageByteArray(input);
        }
        catch (Exception e) {
            System.out.println("Reading image file failed!");
            e.printStackTrace();
            System.exit(-2);
        }
        try {
            images = IrisISO.getImagesFromPackage(image);
        }
        catch (Exception e) {
            System.out.println("Parsing image stream failed!");
            e.printStackTrace();
            System.exit(-3);
        }
        try {
            new File("output").mkdirs();
            for (int i = 0; i < images.size(); ++i) {
                byte[] tmp_img = images.elementAt(i).getImage();
                Utility.writeBytesToFile(tmp_img, "output", input.getName() + "." + (i + 1) + ".parsed." + type);
            }
        }
        catch (Exception e) {
            System.out.println("Writing parsed image failed!");
            e.printStackTrace();
            System.exit(-4);
        }
    }
}

