/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDAICBEFFDirectoryProcessor {
    public static final String pathSeparator = new String(System.getProperty("file.separator"));
    private File _base = null;

    public UIDAICBEFFDirectoryProcessor() throws Exception {
        this(".");
    }

    public UIDAICBEFFDirectoryProcessor(String path) throws Exception {
        this.setBase(path);
    }

    public void setBase(String path) throws Exception {
        this._base = new File(path);
        if (this._base.isFile()) {
            throw new Exception("Base path must be a directory!");
        }
    }

    public Hashtable<String, Vector<String>> process() throws Exception {
        return this.process(null);
    }

    public Hashtable<String, Vector<String>> process(String path) throws Exception {
        if (path != null) {
            this.setBase(path);
        }
        Hashtable<String, Vector<String>> output = new Hashtable<String, Vector<String>>();
        String pathName = new String("");
        try {
            pathName = this._base.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] folders = this._base.list();
        for (int i = 0; i < folders.length; ++i) {
            File tmp_fldr = new File(pathName + pathSeparator + folders[i]);
            if (tmp_fldr.isFile()) continue;
            output.put(folders[i], this.processFolder(tmp_fldr));
        }
        return output;
    }

    public Vector<String> processFolder(File path) throws Exception {
        Vector<String> output = new Vector<String>();
        String pathName = new String("");
        try {
            pathName = path.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] files = path.list();
        for (int i = 0; i < files.length; ++i) {
            String file_name = pathName + pathSeparator + files[i];
            File tmp_fl = new File(file_name);
            if (!tmp_fl.isFile()) continue;
            output.addElement(file_name);
        }
        return output;
    }

    public static String getDateFromFilename(String filename) {
        String tmp_name = filename.replace(".jp2", "").replace(".wsq", "").replace(".jpg", "").replace(".png", "").replace(".gif", "").replace(".bmp", "").replace(".jpeg", "").replace(".bpi", "").replace(".raw", "").replace(".jls", "");
        String[] parts = tmp_name.split("_");
        String date = parts[parts.length - 1];
        String output = date.substring(0, 8) + "T" + date.substring(8, 14) + "Z";
        return output;
    }

    public static String getExtFromFilename(String filename) {
        String output = filename.substring(filename.lastIndexOf(".") + 1);
        return output;
    }

    public static void main(String[] args) {
        System.out.println("daDate: " + UIDAICBEFFDirectoryProcessor.getDateFromFilename("00KC_GUB14132526001-1_0009_02_R000_01_20100416144354625.jp2"));
        if (args.length != 1) {
            System.out.println("You must specify a path to process!");
            System.exit(-1);
        }
        try {
            UIDAICBEFFDirectoryProcessor tmp_proc = new UIDAICBEFFDirectoryProcessor(args[0]);
            Hashtable<String, Vector<String>> tmp_out = tmp_proc.process();
            System.out.println("Directory Contents: " + tmp_out.toString());
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Processing failed with error " + e.toString());
            System.exit(-2);
        }
    }
}

