/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFF;
import com.identix.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.log4j.Logger;

public class ValidateCBEFF {
    public static void main(String[] args) {
        Logger LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.ValidateCBEFF.class");
        if (args.length < 1 || args.length > 1) {
            LOG.error((Object)"Invalid Arguments: Must specify a single CBEFF file to parse\nor -l to read a list of files from STDIN!");
            System.exit(-1);
        } else if (args[0].equalsIgnoreCase("-l")) {
            try {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                String fname = null;
                File input = null;
                fname = stdin.readLine();
                while (fname != null) {
                    byte[] cbeff_file_data = null;
                    try {
                        System.out.println("Attempting to read file \"" + fname + "\" at " + new Date().getTime());
                        input = new File(fname);
                        System.out.println("'Real' file name \"" + input.getAbsolutePath() + "\"");
                        cbeff_file_data = Utility.getImageByteArray(input);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Reading CBEFF file \"" + fname + "\" failed!"), (Throwable)e);
                        System.exit(-2);
                    }
                    try {
                        if (CBEFF.checkISOHeaders(cbeff_file_data)) {
                            LOG.error((Object)("CBEFF file \"" + fname + "\" is VALID"));
                        } else {
                            LOG.error((Object)("CBEFF file \"" + fname + "\" is NOT VALID"));
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Validating CBEFF file \"" + fname + "\" failed!"), (Throwable)e);
                        System.exit(-2);
                    }
                    fname = stdin.readLine();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Validating CBEFF files failed!", (Throwable)e);
                System.exit(-3);
            }
        } else {
            byte[] cbeff_file_data = null;
            File input = null;
            try {
                input = new File(args[0]);
                cbeff_file_data = Utility.getImageByteArray(input);
            }
            catch (Exception e) {
                LOG.error((Object)"Reading CBEFF file failed!", (Throwable)e);
                System.exit(-2);
            }
            try {
                if (CBEFF.checkISOHeaders(cbeff_file_data)) {
                    LOG.error((Object)("CBEFF file \"" + args[0] + "\" is VALID"));
                } else {
                    LOG.error((Object)("CBEFF file \"" + args[0] + "\" is NOT VALID"));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Validating CBEFF file \"" + args[0] + "\" failed!"), (Throwable)e);
                System.exit(-2);
            }
        }
    }
}

