/*
 * Decompiled with CFR 0.152.
 */
package com.identix.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream {
    private InputStream iIs;
    private int iBuffer;
    private int iNextBit = 8;

    public BitInputStream(InputStream aIs) {
        this.iIs = aIs;
    }

    public synchronized int readBits(short aNumberOfBits) throws IOException {
        int value = 0;
        for (int i = aNumberOfBits - 1; i >= 0; --i) {
            value |= this.readBit() << i;
        }
        return value;
    }

    public synchronized int readBit() throws IOException {
        if (this.iIs == null) {
            throw new IOException("Already closed");
        }
        if (this.iNextBit == 8) {
            this.iBuffer = this.iIs.read();
            if (this.iBuffer == -1) {
                throw new EOFException();
            }
            this.iNextBit = 0;
        }
        int bit = this.iBuffer & 1 << this.iNextBit;
        ++this.iNextBit;
        bit = bit == 0 ? 0 : 1;
        return bit;
    }

    public void close() throws IOException {
        this.iIs.close();
        this.iIs = null;
    }
}

