/*
 * Decompiled with CFR 0.152.
 */
package com.identix.util;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream {
    private OutputStream iOs;
    private int iBuffer;
    private int iBitCount;

    public BitOutputStream(OutputStream aOs) {
        this.iOs = aOs;
    }

    public synchronized void writeBit(int aBit) throws IOException {
        if (this.iOs == null) {
            throw new IOException("Already closed");
        }
        if (aBit != 0 && aBit != 1) {
            throw new IOException(aBit + " is not a bit");
        }
        this.iBuffer |= aBit << this.iBitCount;
        ++this.iBitCount;
        if (this.iBitCount == 8) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        if (this.iBitCount > 0) {
            this.iOs.write((byte)this.iBuffer);
            this.iBitCount = 0;
            this.iBuffer = 0;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.iOs.close();
        this.iOs = null;
    }

    public synchronized void writeBits(int aValue, short aNumBits) throws IOException {
        for (int i = aNumBits - 1; i >= 0; --i) {
            this.writeBit(aValue >> i & 1);
        }
    }

    public static int getRequiredNumOfBits(int aMaxValue) {
        int curBit;
        if (aMaxValue == 0) {
            return 1;
        }
        for (curBit = 31; curBit >= 0 && (aMaxValue & 1 << curBit) <= 0; --curBit) {
        }
        return curBit + 1;
    }
}

