/*
 * Decompiled with CFR 0.152.
 */
package com.identix.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;

public class DynamicFilenameFilter
implements FilenameFilter {
    private Vector _patterns = new Vector();
    private boolean _narrowing = true;

    public DynamicFilenameFilter() {
        this(true);
    }

    public DynamicFilenameFilter(boolean narrowing) {
        this._narrowing = narrowing;
    }

    public void setPatterns(Vector newPatterns) {
        this._patterns = new Vector();
        for (int i = 0; i < newPatterns.size(); ++i) {
            this._patterns.addElement(newPatterns.elementAt(i));
        }
    }

    private boolean contains(String pool, String search) {
        return pool.indexOf(search) != -1;
    }

    private boolean containsModified(String name, String currentPattern) {
        if (currentPattern.startsWith("!")) {
            if ((currentPattern = currentPattern.substring(1)).startsWith("=")) {
                return !name.equals(currentPattern = currentPattern.substring(1));
            }
            if (currentPattern.startsWith("*")) {
                if (currentPattern.endsWith("*")) {
                    return !this.contains(name, currentPattern.substring(1, currentPattern.length() - 1));
                }
                return !name.endsWith(currentPattern.substring(1));
            }
            if (currentPattern.endsWith("*")) {
                return !name.startsWith(currentPattern.substring(0, currentPattern.length() - 1));
            }
            return !this.contains(name, currentPattern);
        }
        if (currentPattern.startsWith("=")) {
            return name.equals(currentPattern = currentPattern.substring(1));
        }
        if (currentPattern.startsWith("*")) {
            if (currentPattern.endsWith("*")) {
                return this.contains(name, currentPattern.substring(1, currentPattern.length() - 1));
            }
            return name.endsWith(currentPattern.substring(1));
        }
        if (currentPattern.endsWith("*")) {
            return name.startsWith(currentPattern.substring(0, currentPattern.length() - 1));
        }
        return this.contains(name, currentPattern);
    }

    public boolean accept(File dir, String name) {
        File test_dir = null;
        try {
            test_dir = new File(dir.getCanonicalPath() + File.separator + name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!test_dir.isFile()) {
            return true;
        }
        String currentPattern = new String("");
        boolean response = true;
        if (this._patterns.isEmpty()) {
            return true;
        }
        if (this._patterns.elementAt(0) == "*") {
            return true;
        }
        for (int i = 0; i < this._patterns.size(); ++i) {
            currentPattern = new String((String)this._patterns.elementAt(i));
            boolean new_resp = this.containsModified(name, currentPattern);
            if (i == 0) {
                response = new_resp;
                continue;
            }
            if (this._narrowing) {
                response &= new_resp;
                continue;
            }
            response |= new_resp;
        }
        return response;
    }

    public String toString() {
        String buffer = new String("");
        for (int i = 0; i < this._patterns.size(); ++i) {
            buffer = buffer + (String)this._patterns.elementAt(i);
        }
        return buffer;
    }
}

