/*
 * Decompiled with CFR 0.152.
 */
package com.identix.util;

import com.identix.util.DynamicFilenameFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListGrabber {
    private File _baseDirectory;
    private StringTokenizer _patterns;
    private boolean _match;
    private int _numPatterns;

    public FileListGrabber(String baseDirName, String filePattern) {
        this(new File(baseDirName), filePattern);
    }

    public FileListGrabber(File baseDir, String filePattern) {
        this._baseDirectory = baseDir;
        if (filePattern.equals("*")) {
            this._match = false;
        } else {
            this._match = true;
            this._patterns = new StringTokenizer(filePattern);
            this._numPatterns = this._patterns.countTokens();
        }
    }

    public Vector<String> getList() {
        return this.getList(true);
    }

    public Vector<String> getList(boolean narrowing) {
        Vector<String> patterns = new Vector<String>();
        DynamicFilenameFilter filter = new DynamicFilenameFilter(narrowing);
        if (this._patterns != null) {
            while (this._patterns.hasMoreTokens()) {
                patterns.addElement(this._patterns.nextToken());
            }
        }
        filter.setPatterns(patterns);
        Vector<String> output = this.descendFS(this._baseDirectory, filter);
        return output;
    }

    public Vector<String> descendFS(File path, FilenameFilter filter) {
        String pathName = new String("");
        String pathSeparator = new String(System.getProperty("file.separator"));
        try {
            pathName = path.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        Vector<String> output = new Vector<String>();
        if (path.isFile()) {
            output.addElement(pathName);
        } else {
            String[] children = path.list(filter);
            for (int i = 0; i < children.length; ++i) {
                this.append(output, this.descendFS(new File(pathName + pathSeparator + children[i]), filter));
            }
        }
        return output;
    }

    public Vector<File> getFileList() {
        return this.getFileList(true);
    }

    public Vector<File> getFileList(boolean narrowing) {
        Vector<String> patterns = new Vector<String>();
        DynamicFilenameFilter filter = new DynamicFilenameFilter(narrowing);
        if (this._patterns != null) {
            while (this._patterns.hasMoreTokens()) {
                patterns.addElement(this._patterns.nextToken());
            }
        }
        filter.setPatterns(patterns);
        System.out.println("Descending: " + this._baseDirectory + " filter: " + filter);
        Vector<File> output = this.descendFileFS(this._baseDirectory, filter);
        return output;
    }

    public Vector<File> descendFileFS(File path, FilenameFilter filter) {
        String pathName = new String("");
        String pathSeparator = new String(System.getProperty("file.separator"));
        try {
            pathName = path.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        Vector<File> output = new Vector<File>();
        if (path.isFile()) {
            output.addElement(path);
        } else {
            String[] children = path.list(filter);
            for (int i = 0; i < children.length; ++i) {
                this.append(output, this.descendFileFS(new File(pathName + pathSeparator + children[i]), filter));
            }
        }
        return output;
    }

    public void append(Vector base, Vector extension) {
        for (int i = 0; i < extension.size(); ++i) {
            base.addElement(extension.elementAt(i));
        }
    }

    public static void main(String[] args) {
        String dir = new String("D:\\temp\\TEKSOL_Drive\\TEP_Images");
        if (args.length == 1) {
            dir = new String(args[0]);
        }
        FileListGrabber grabber = new FileListGrabber(dir, "*.wsq *.jpg *.tif *.jp2 *.png *.jpeg *.raw *.bpi *.jls");
        Vector<String> files = grabber.getList(false);
        for (int i = 0; i < files.size(); ++i) {
            System.out.println("" + i + ": " + files.elementAt(i));
        }
        System.exit(0);
    }
}

