/*
 * Decompiled with CFR 0.152.
 */
package com.identix.util;

import com.identix.util.BitInputStream;
import com.identix.util.Timing;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utility {
    public static final Logger LOG = Logger.getLogger((String)"com.identix.util.Utility.class");
    public static final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    public static final String pathSeparator = new String(System.getProperty("file.separator"));

    public static String getElapsedString(long elapse) {
        long spare_mili = elapse % 1000L;
        long secs = elapse / 1000L;
        long spare_secs = secs % 60L;
        long mins = secs / 60L;
        long spare_mins = mins % 60L;
        long hours = mins / 60L;
        long spare_hours = hours % 24L;
        long days = hours / 24L;
        return "" + days + "d " + spare_hours + "h " + spare_mins + "m " + spare_secs + "s " + spare_mili + "ms";
    }

    public static String expand(Enumeration keys) {
        StringBuffer output = new StringBuffer();
        boolean first = true;
        while (keys.hasMoreElements()) {
            if (first) {
                output.append(keys.nextElement().toString());
                first = false;
                continue;
            }
            output.append(" " + keys.nextElement().toString());
        }
        return output.toString();
    }

    public static byte[] convertFromBase64(String input) {
        return Utility.convertFromBase64(input.getBytes());
    }

    public static byte[] convertFromBase64(byte[] input) {
        byte[] result = null;
        if (input != null && input.length > 0) {
            result = Base64.decodeBase64((byte[])input);
        }
        return result;
    }

    public static byte[] convertToBase64(byte[] input) {
        byte[] result = null;
        if (input != null && input.length > 0) {
            result = Base64.encodeBase64((byte[])input);
        }
        return result;
    }

    public static byte[] convertClobToByteArray(Clob input) throws Exception {
        BufferedInputStream bin = new BufferedInputStream(input.getAsciiStream());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int i = bin.read();
        while (i != -1) {
            bout.write(i);
            i = bin.read();
        }
        return bout.toByteArray();
    }

    public static Date parseDate(String input) {
        if (input != null) {
            try {
                return format.parse(input);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String formatDate(Date input) {
        if (input != null) {
            return format.format(input);
        }
        return "";
    }

    public static byte[] getImageByteArray(String filename) throws Exception {
        return Utility.getImageByteArray(new File(filename), null);
    }

    public static byte[] getImageByteArray(File imagefile) throws Exception {
        return Utility.getImageByteArray(imagefile, null);
    }

    public static byte[] getImageByteArray(File imagefile, Timing timer) throws Exception {
        if (timer != null) {
            timer.setStart();
        }
        FileInputStream stream = null;
        stream = new FileInputStream(imagefile);
        byte[] image = new byte[stream.available()];
        if (stream.read(image, 0, image.length) != image.length) {
            if (timer != null) {
                timer.setEnd();
            }
            throw new IOException("Could not read image file '" + imagefile.getAbsolutePath() + "'.");
        }
        stream.close();
        if (timer != null) {
            timer.setEnd();
        }
        return image;
    }

    public static byte[] getImageByteArray(DataInputStream stream, int BUFFER, Timing timer) throws Exception {
        if (timer != null) {
            timer.setStart();
        }
        LOG.info((Object)"Starting reading data stream.");
        byte[] image = null;
        Vector<byte[]> inputs = new Vector<byte[]>();
        byte[] tmp_image = null;
        try {
            while (true) {
                int red;
                if ((red = stream.read(tmp_image = new byte[BUFFER], 0, tmp_image.length)) == -1) {
                    LOG.info((Object)"Finished reading data stream.");
                    break;
                }
                if (red != tmp_image.length) {
                    LOG.trace((Object)("Partial read from data stream: READ=\"" + red + "\" EXPECTED=\"" + tmp_image.length + "\""));
                    tmp_image = Utility.trim(tmp_image, red);
                }
                inputs.add(tmp_image);
            }
        }
        catch (EOFException eofe) {
            LOG.info((Object)"Finished reading data stream.");
        }
        catch (IOException e) {
            LOG.error((Object)"Failure reading data stream.", (Throwable)e);
            throw e;
        }
        finally {
            stream.close();
        }
        if (inputs != null && inputs.size() > 0) {
            image = Utility.assembleByteArray(inputs);
        } else {
            LOG.error((Object)"No data retrieved from DataInputStream!");
        }
        if (timer != null) {
            timer.setEnd();
        }
        return image;
    }

    public static byte[] trim(byte[] input, int len) {
        if (input.length < len) {
            return input;
        }
        byte[] output = new byte[len];
        for (int i = 0; i < len; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static byte[] assembleByteArray(Vector<byte[]> inputs) {
        LOG.info((Object)("Assembling byte array vector of size " + (inputs != null ? "" + inputs.size() : "0")));
        byte[] output = null;
        if (inputs != null && inputs.size() > 0) {
            int new_size = Utility.getSize(inputs);
            LOG.info((Object)("Newly assembled array will be of size " + new_size));
            output = new byte[new_size];
            int k = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                byte[] tmp_array = inputs.elementAt(i);
                int j = 0;
                while (j < tmp_array.length) {
                    output[k] = tmp_array[j];
                    ++j;
                    ++k;
                }
            }
        }
        return output;
    }

    public static int getSize(Vector<byte[]> input) {
        int output = 0;
        if (input != null && input.size() > 0) {
            for (int i = 0; i < input.size(); ++i) {
                output += input.elementAt(i).length;
            }
        }
        return output;
    }

    public static void writeStringToFile(String data, String path, String filename) throws Exception {
        BufferedWriter bout = new BufferedWriter(new FileWriter(path + pathSeparator + filename));
        bout.write(data, 0, data.length());
        bout.close();
    }

    public static void writeBytesToFile(byte[] data, String path, String filename) throws Exception {
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(path + pathSeparator + filename));
        bout.write(data, 0, data.length);
        bout.close();
    }

    public static void writeBytesToFile(byte[] data, File output) throws Exception {
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(output));
        bout.write(data, 0, data.length);
        bout.close();
    }

    public static byte[] intToByteArray(int integer) {
        int byteNum = (40 - Integer.numberOfLeadingZeros(integer < 0 ? ~integer : integer)) / 8;
        byte[] byteArray = new byte[byteNum];
        for (int n = 0; n < byteNum; ++n) {
            byteArray[byteNum - 1 - n] = (byte)(integer >>> n * 8);
        }
        return byteArray;
    }

    public static byte[] intToByteArray(int integer, int width) {
        byte[] byteArray = new byte[width];
        for (int n = 0; n < width; ++n) {
            byteArray[width - 1 - n] = n > 3 ? (byte)0 : (byte)(integer >>> n * 8);
        }
        return byteArray;
    }

    public static byte[] longToByteArray(long input, int width) {
        byte[] byteArray = new byte[width];
        for (int n = 0; n < width; ++n) {
            byteArray[width - 1 - n] = n > 7 ? (byte)0 : (byte)(input >>> n * 8);
        }
        return byteArray;
    }

    public static byte smallIntToByte(int integer) {
        if (integer <= 256) {
            byte[] output = Utility.intToByteArray(integer, 1);
            return output[0];
        }
        return 0;
    }

    public static int[] getBitArray(byte[] input) throws Exception {
        if (input != null && input.length > 0) {
            int[] output = new int[input.length * 8];
            BitInputStream bin = new BitInputStream(new ByteArrayInputStream(input));
            int i = 0;
            int l = 0;
            while (i < input.length) {
                int j = 7;
                int k = 0;
                while (k < 8) {
                    output[l + j] = bin.readBit();
                    ++k;
                    --j;
                }
                ++i;
                l += 8;
            }
            bin.close();
            LOG.debug((Object)("Generated Int Bit Array \"" + Utility.intArrayToString(output) + "\""));
            return output;
        }
        return null;
    }

    public static int getInt(int ... input) throws Exception {
        if (input != null && input.length > 0) {
            int output = 0;
            try {
                int i = input.length - 1;
                int j = 0;
                while (i > -1) {
                    output += input[i] * (int)Math.pow(2.0, j);
                    --i;
                    ++j;
                }
            }
            catch (Exception e) {
                throw new Exception("Input \"" + Utility.intArrayToString(input) + "\" too many bits for storage in 'int'!", e);
            }
            return output;
        }
        return 0;
    }

    public static long getLong(int ... input) throws Exception {
        if (input != null && input.length > 0) {
            long output = 0L;
            try {
                int i = input.length - 1;
                int j = 0;
                while (i > -1) {
                    output += (long)input[i] * (long)Math.pow(2.0, j);
                    --i;
                    ++j;
                }
            }
            catch (Exception e) {
                throw new Exception("Input \"" + Utility.intArrayToString(input) + "\" too many bits for storage in 'int'!", e);
            }
            return output;
        }
        return 0L;
    }

    public static String intArrayToString(int ... input) {
        String output = "[";
        if (input != null && input.length > 0) {
            for (int i = 0; i < input.length; ++i) {
                output = output + "" + input[i];
                if (i != input.length - 1) continue;
                output = output + "]";
            }
            return output;
        }
        return "";
    }

    public static void main(String[] args) {
        try {
            System.out.println("Testing int->byte converter with 275352 width 6...");
            byte[] ours = Utility.intToByteArray(275352, 6);
            int[] ours_bits = Utility.getBitArray(ours);
            System.out.println("Bits: " + Utility.intArrayToString(ours_bits));
            System.out.println("Int: " + Utility.getInt(ours_bits));
            System.out.println("BigInt: " + new BigInteger(ours).intValue());
            System.out.println("BigLong: " + new BigInteger(ours).longValue());
        }
        catch (Exception e) {
            System.out.println("Something failed...");
            e.printStackTrace();
        }
    }
}

