/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec;

import in.gov.uidai.ec.EnrolSpringConfig;
import in.gov.uidai.ec.StationRegistrationInfoHelper;
import in.gov.uidai.ec.biometrics.qssitv.HrmiITVEngine;
import in.gov.uidai.ec.biometrics.qssitv.HrmiQSSEngine;
import in.gov.uidai.ec.db.DerbyDBDeployer;
import in.gov.uidai.ec.icas.logging.UIDLogManager;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.icas.util.FileLockingResource;
import in.gov.uidai.ec.icas.util.ILockingResource;
import in.gov.uidai.ec.icas.util.SingleApplication;
import in.gov.uidai.ec.security.impl.JarIntegrityCheck;
import in.gov.uidai.ec.service.machineidentity.MachineInfo;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.spi.IITVEngine;
import in.gov.uidai.qssitv.spi.IQSSEngine;
import in.gov.uidai.swing.UidSplashScreen;
import in.gov.uidai.swing.fontman.FontManager;
import in.gov.uidai.swing.laf.UidLookAndFeel;
import in.gov.uidai.swing.notify.AlwaysOnTopOptionPane;
import in.gov.uidai.swing.translit.TransliterationSetup;
import java.awt.Color;
import java.security.Provider;
import java.security.Security;
import javax.sql.DataSource;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public final class EnrolMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrolMain.class);

    private EnrolMain() {
    }

    public static void main(String[] args) throws Exception {
        EnrolMain.initialize();
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
        System.runFinalization();
    }

    public static void initialize() throws Exception {
        try {
            StationRegistrationInfoHelper stationRegistrationInfoHelper = StationRegistrationInfoHelper.INSTANCE;
        }
        catch (UnsatisfiedLinkError e) {
            AlwaysOnTopOptionPane.create().messageType(1).optionType(-1).message("The application is tampered. Cannot proceed. Please re install the application.").title("Aadhaar").winIcon("res/images/frame_icon.png").show();
            System.exit(0);
        }
        UidSplashScreen.getInst().setStatus("Archiving old logs and starting fresh");
        UIDLogManager.archive();
        UIDLogManager.setup((String)"config/logback.ecmp.xml");
        boolean signVerification = false;
        try {
            signVerification = new JarIntegrityCheck().verifyJar(ApplicationVersion.VERSION);
        }
        catch (Exception e) {
            LOGGER.error("unable to verify jar integrity for the application", (Throwable)e);
        }
        if (!signVerification) {
            AlwaysOnTopOptionPane.create().messageType(1).optionType(-1).message("The application is invalid as one or more jar files seems to be tampered.Cannot proceed.Please re install the application.").title("Aadhaar").winIcon("res/images/frame_icon.png").show();
            System.exit(0);
        }
        FontManager.getInst();
        new Thread(() -> MachineInfo.printMachineInfo()).start();
        try {
            LOGGER.debug("Setting up version info and status area...");
            UidSplashScreen.getInst().setVersionInfo("Enrolment Client v" + ApplicationVersion.FULLDISPLAYVERSION, 5, 150, 400, 100);
            UidSplashScreen.getInst().setStatusArea(100, 220, 300, 20, Color.decode("#348f47"));
        }
        catch (Exception e) {
            LOGGER.error("Error while setting status area in the splash screen", (Throwable)e);
        }
        LOGGER.info("Launching ECMP Client @ version:" + ApplicationVersion.FULLDISPLAYVERSION);
        new Thread(() -> MachineInfo.printMachineInfo()).start();
        UidSplashScreen.getInst().setStatus("Setting up look and feel");
        LOGGER.debug("setting up look and feel");
        try {
            UIManager.setLookAndFeel((LookAndFeel)new UidLookAndFeel());
        }
        catch (Exception e) {
            LOGGER.error("unable to set look and feel", (Throwable)e);
        }
        UidSplashScreen.getInst().setStatus("Locking application");
        SingleApplication sapp = new SingleApplication();
        sapp.setLockingResource((ILockingResource)new FileLockingResource("ec.lock"));
        sapp.setErrorMessage("Aadhaar", "<html>Another instance of the Aadhaar enrolment client is already running<br>on this machine. This application will now terminate");
        sapp.checkAndTerminate();
        UidSplashScreen.getInst().setStatus("Deploying databases, if any");
        LOGGER.debug("deploying databases, if any");
        new DerbyDBDeployer().deploy();
        Security.addProvider((Provider)new BouncyCastleProvider());
        UidSplashScreen.getInst().setStatus("Establishing link with remote QSS/ITV engine");
        LOGGER.debug("preloading the QSS engine");
        Qssitv.getInst().register((IQSSEngine)new HrmiQSSEngine());
        LOGGER.debug("preloading the ITV engine");
        Qssitv.getInst().register((IITVEngine)new HrmiITVEngine());
        UidSplashScreen.getInst().setStatus("Setting up transliteration system");
        new TransliterationSetup().loadAll();
        try {
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{EnrolSpringConfig.class});
            context.registerShutdownHook();
            LOGGER.debug("warming up registrar db");
            UidSplashScreen.getInst().setStatus("Warming up registrar db");
            new DerbyDBDeployer().warmup((DataSource)context.getBean("ds.registrar"));
            LOGGER.debug("warming up runtime db");
            UidSplashScreen.getInst().setStatus("Warming up runtime db");
            new DerbyDBDeployer().warmup((DataSource)context.getBean("ds.runtime"));
            ((DerbyDBDeployer)context.getBean("derbyDBDeployer")).runMigration();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            System.exit(0);
        }
        UidSplashScreen.getInst().setStatus("Going visual");
        UidSplashScreen.getInst().dispose();
    }
}

