/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import in.gov.uidai.dm.handler.DefaultRequestHandler;
import in.gov.uidai.dm.manage.DesktopNotification;
import in.gov.uidai.dm.net.SocketServer;
import java.io.File;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        System.setProperty("visualvm.display.name", "Device Manager");
        JoranConfigurator jconf = new JoranConfigurator();
        ClassLoader cldr = Main.class.getClassLoader();
        try {
            LoggerContext logCtxt = (LoggerContext)LoggerFactory.getILoggerFactory();
            jconf.setContext((Context)logCtxt);
            logCtxt.reset();
            jconf.doConfigure(cldr.getResource("res/dm/config/logback.dm.xml"));
        }
        catch (Exception exep) {
            exep.printStackTrace();
        }
        LOGGER.info("starting UID device manager");
        DesktopNotification.getInst();
        CompositeConfiguration svcConfig = new CompositeConfiguration();
        File propConfFile = new File("conf/dm.svc.properties");
        try {
            PropertiesConfiguration pconf = new PropertiesConfiguration(propConfFile);
            svcConfig.addConfiguration((Configuration)pconf);
        }
        catch (Exception exep) {
            exep.printStackTrace();
        }
        new DefaultRequestHandler(10);
        final SocketServer sockSrv = new SocketServer((Configuration)svcConfig);
        sockSrv.start();
        Runnable shutdown = new Runnable(){

            @Override
            public void run() {
                sockSrv.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdown));
    }

    private Main() {
    }
}

