/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.handler;

import in.gov.uidai.dm.proc.IHandlerContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDelegate
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDelegate.class);
    private final IHandlerContext hCtxt;

    protected AbstractDelegate(IHandlerContext ctxt) {
        this.hCtxt = ctxt;
    }

    protected final IHandlerContext getHandlerContext() {
        return this.hCtxt;
    }

    protected final void writeResponse(Object response) {
        if (this.hCtxt == null) {
            return;
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Marshaller marshal = JAXBContext.newInstance((Class[])new Class[]{response.getClass()}).createMarshaller();
            marshal.setProperty("jaxb.fragment", (Object)true);
            if (LOGGER.isDebugEnabled()) {
                ByteArrayOutputStream logBuf = new ByteArrayOutputStream();
                marshal.setProperty("jaxb.formatted.output", (Object)true);
                marshal.marshal(response, (OutputStream)logBuf);
                LOGGER.debug("=== Outgoing Response Start ===");
                LOGGER.debug("\n" + logBuf.toString());
                LOGGER.debug("=== Outgoing Response End ===");
            }
            marshal.setProperty("jaxb.formatted.output", (Object)false);
            marshal.marshal(response, (OutputStream)output);
            output.flush();
            output.close();
            this.hCtxt.writeResponse(output.toByteArray());
            LOGGER.debug("response sent");
        }
        catch (Exception exep) {
            LOGGER.warn("write to socket failed", (Throwable)exep);
            try {
                this.hCtxt.closeConnection();
            }
            catch (Exception exep1) {
                LOGGER.warn("closing of socket failed", (Throwable)exep1);
            }
        }
    }
}

