/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.handler;

import in.gov.uidai.dm.manage.DesktopNotification;
import in.gov.uidai.dm.proc.IHandlerContext;
import in.gov.uidai.dm.xml.APP;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppEntity.class);
    private static final Map<String, AppEntity> ENTITY_MAP = new HashMap<String, AppEntity>();
    private static final Timer HB_TIMER = new Timer("Client Timeout Timer", true);
    private final String entityName;
    private final String connectionId;
    private APP app;
    private TimerTask pingTask;
    private IHandlerContext hCtxt;

    public static final Collection<AppEntity> listAll() {
        return ENTITY_MAP.values();
    }

    public static final AppEntity get(String appName) {
        return ENTITY_MAP.get(appName);
    }

    public static final AppEntity getByConnectionId(String connId) {
        for (AppEntity entity : ENTITY_MAP.values()) {
            if (!StringUtils.equalsIgnoreCase((String)connId, (String)entity.connectionId)) continue;
            return entity;
        }
        return null;
    }

    public AppEntity(String name, String connId) {
        this.entityName = name;
        this.connectionId = connId;
        ENTITY_MAP.put(this.entityName, this);
        LOGGER.debug("App added [" + this.entityName + "]");
    }

    public void waitForPing(long timeout) {
        if (this.pingTask != null) {
            this.pingTask.cancel();
            HB_TIMER.purge();
        }
        this.pingTask = new TimerTask(){

            @Override
            public void run() {
                LOGGER.debug("heartbeat timeout [" + AppEntity.this.entityName + "]");
                AppEntity.this.remove();
            }
        };
        HB_TIMER.schedule(this.pingTask, TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS));
        LOGGER.debug("Heartbeat for [" + this.entityName + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        AppEntity appEntity = this;
        synchronized (appEntity) {
            if (this.pingTask != null) {
                this.pingTask.cancel();
                HB_TIMER.purge();
            }
            ENTITY_MAP.remove(this.entityName);
        }
        LOGGER.debug("App removed [" + this.app + "]");
        DesktopNotification.getInst().showMessage("Client removed: " + this.app);
    }

    public APP getApp() {
        return this.app;
    }

    public void setApp(APP value) {
        this.app = value;
    }

    public void setHandlerContext(IHandlerContext ctxt) {
        this.hCtxt = ctxt;
    }

    public IHandlerContext getHandlerContext() {
        return this.hCtxt;
    }
}

