/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.handler;

import in.gov.uidai.dm.handler.AppEntity;
import in.gov.uidai.dm.handler.ClientCommandRequestDelegate;
import in.gov.uidai.dm.handler.DmEventRequestDelegate;
import in.gov.uidai.dm.handler.VDMEntity;
import in.gov.uidai.dm.proc.IHandlerContext;
import in.gov.uidai.dm.proc.RequestHandler;
import in.gov.uidai.dm.xml.ClientCommandRequest;
import in.gov.uidai.dm.xml.DeviceManagerEventRequest;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestHandler
extends RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestHandler.class);
    private static final int QUEUE_FACTOR = 50;
    private final ExecutorService executor;

    public DefaultRequestHandler(int maxHandlers) {
        this.executor = new ThreadPoolExecutor(1, maxHandlers, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxHandlers * 50));
        LOGGER.debug("handler factory ready");
    }

    @Override
    public void execute(IHandlerContext hctxt) {
        LOGGER.debug("handling " + hctxt.getRequest().getClass().getName());
        if (hctxt.getRequest() instanceof DeviceManagerEventRequest) {
            DmEventRequestDelegate delegate = new DmEventRequestDelegate(hctxt);
            this.executor.submit(delegate);
        } else if (hctxt.getRequest() instanceof ClientCommandRequest) {
            ClientCommandRequestDelegate delegate = new ClientCommandRequestDelegate(hctxt);
            this.executor.submit(delegate);
        }
    }

    @Override
    public void connectionClosed(String connectionId) {
        VDMEntity vdmEntity;
        AppEntity appEntity = AppEntity.getByConnectionId(connectionId);
        if (appEntity != null) {
            appEntity.remove();
        }
        if ((vdmEntity = VDMEntity.getByConnectionId(connectionId)) != null) {
            vdmEntity.remove();
        }
    }
}

