/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.handler;

import in.gov.uidai.dm.handler.AbstractDelegate;
import in.gov.uidai.dm.handler.AppEntity;
import in.gov.uidai.dm.handler.VDMBroadcast;
import in.gov.uidai.dm.handler.VDMEntity;
import in.gov.uidai.dm.manage.DesktopNotification;
import in.gov.uidai.dm.proc.IHandlerContext;
import in.gov.uidai.dm.xml.APP;
import in.gov.uidai.dm.xml.Arrival;
import in.gov.uidai.dm.xml.Connect;
import in.gov.uidai.dm.xml.ConnectResponse;
import in.gov.uidai.dm.xml.DeviceManagerEventRequest;
import in.gov.uidai.dm.xml.DeviceManagerEventResponse;
import in.gov.uidai.dm.xml.Ping;
import in.gov.uidai.dm.xml.Removal;
import in.gov.uidai.dm.xml.Return;
import in.gov.uidai.dm.xml.VDM;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmEventRequestDelegate
extends AbstractDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmEventRequestDelegate.class);
    private static final int PING_FACTOR = 2;
    private final int heartbeat;

    public DmEventRequestDelegate(IHandlerContext ctxt) {
        super(ctxt);
        this.heartbeat = ctxt.getConfiguration().getInt("heartbeat", 10);
    }

    @Override
    public void run() {
        DeviceManagerEventRequest dmer = (DeviceManagerEventRequest)this.getHandlerContext().getRequest();
        Connect connect = dmer.getConnect();
        Arrival arrival = dmer.getArrival();
        Ping ping = dmer.getPing();
        Removal removal = dmer.getRemoval();
        if (connect != null) {
            DeviceManagerEventResponse dmeo = this.createConnectResponse(dmer.getRequestId());
            VDM vdm = connect.getVDM();
            APP app = connect.getAPP();
            if (vdm != null) {
                String vdmName = vdm.getVdmName();
                LOGGER.debug("received CONNECT for vdm [" + vdmName + "]");
                VDMEntity vdmEnt = VDMEntity.get(vdmName);
                if (vdmEnt != null) {
                    LOGGER.debug("removing old vdm with same name");
                    vdmEnt.remove();
                }
                vdmEnt = new VDMEntity(vdmName, this.getHandlerContext().getConnectionId());
                vdmEnt.setVDM(connect.getVDM());
                vdmEnt.waitForPing(this.heartbeat * 2);
                this.writeResponse(dmeo);
            } else if (app != null) {
                String appName = app.getAppName();
                LOGGER.debug("received CONNECT for app [" + appName + "]");
                AppEntity appEnt = AppEntity.get(appName);
                if (appEnt != null) {
                    LOGGER.debug("removing old app with same name");
                    appEnt.remove();
                }
                appEnt = new AppEntity(appName, this.getHandlerContext().getConnectionId());
                appEnt.setApp(app);
                appEnt.setHandlerContext(this.getHandlerContext());
                DesktopNotification.getInst().showMessage("Client arrived: " + app);
                appEnt.waitForPing(this.heartbeat * 2);
                this.writeResponse(dmeo);
                VDMBroadcast.getInst().clientArrived(appEnt);
            }
        } else if (arrival != null) {
            DeviceManagerEventResponse dmeo = this.createResponse(dmer.getRequestId());
            String vdmName = arrival.getVdmName();
            LOGGER.debug("received ARRIVAL for vdm [" + vdmName + "]");
            VDMEntity vdmEnt = VDMEntity.get(vdmName);
            if (vdmEnt == null) {
                LOGGER.debug("vdm entity not found");
                dmeo.getReturn().setValue("Failure");
                dmeo.getReturn().setFailureReason("InternalError_Unknown");
            } else {
                LOGGER.debug("updating vdm entity with arrival");
                vdmEnt.addDevice(arrival);
                DesktopNotification.getInst().showMessage("Device arrived: " + arrival);
            }
            this.writeResponse(dmeo);
            if (vdmEnt != null) {
                VDMBroadcast.getInst().deviceArrived(arrival);
            }
        } else if (ping != null) {
            DeviceManagerEventResponse dmeo = this.createResponse(dmer.getRequestId());
            String entityName = ping.getVdmName();
            LOGGER.debug("received HEARTBEAT for entity [" + entityName + "]");
            VDMEntity vdmEnt = VDMEntity.get(entityName);
            AppEntity appEnt = AppEntity.get(entityName);
            if (vdmEnt != null) {
                LOGGER.debug("vdm entity found");
                vdmEnt.waitForPing(this.heartbeat * 2);
            } else if (appEnt != null) {
                LOGGER.debug("app entity found");
                appEnt.waitForPing(this.heartbeat * 2);
            } else {
                LOGGER.debug("entity not found");
                dmeo.getReturn().setValue("Failure");
                dmeo.getReturn().setFailureReason("InternalError_Unknown");
            }
            this.writeResponse(dmeo);
        } else if (removal != null) {
            DeviceManagerEventResponse dmeo = this.createResponse(dmer.getRequestId());
            String vdmUri = removal.getDeviceURI();
            LOGGER.debug("received REMOVAL for device uri [" + vdmUri + "]");
            Iterator<VDMEntity> iter = VDMEntity.listAll().iterator();
            Arrival devEntry = null;
            while (iter.hasNext() && (devEntry = iter.next().removeDevice(removal)) == null) {
            }
            if (devEntry == null) {
                LOGGER.debug("vdm entity not found for device");
                dmeo.getReturn().setValue("Failure");
                dmeo.getReturn().setFailureReason("InternalError_Unknown");
            } else {
                DesktopNotification.getInst().showMessage("Device removed " + devEntry);
                LOGGER.debug("firing device removal");
                VDMBroadcast.getInst().deviceRemoved(removal);
            }
            try {
                this.writeResponse(dmeo);
            }
            catch (Exception exep) {
                LOGGER.debug("unable to write response to VDM", (Throwable)exep);
            }
        }
    }

    private DeviceManagerEventResponse createConnectResponse(String reqId) {
        DeviceManagerEventResponse dmeo = new DeviceManagerEventResponse();
        dmeo.setRequestId(reqId);
        Return ret = new Return();
        ret.setValue("Success");
        ret.setFailureReason("Success");
        dmeo.setReturn(ret);
        ConnectResponse cresp = new ConnectResponse();
        String apiVersion = this.getHandlerContext().getConfiguration().getString("dm.api.version", "1.0.0.1");
        cresp.setApiVersion(apiVersion);
        String dmName = this.getHandlerContext().getConfiguration().getString("dm.name", "{name}");
        cresp.setDmName(dmName);
        String dmVendor = this.getHandlerContext().getConfiguration().getString("dm.vendor", "{vendor}");
        cresp.setVendor(dmVendor);
        String dmVersion = this.getHandlerContext().getConfiguration().getString("dm.version", "{version}");
        cresp.setDmVersion(dmVersion);
        cresp.setHeartBeat(this.heartbeat);
        dmeo.setConnectResponse(cresp);
        return dmeo;
    }

    private DeviceManagerEventResponse createResponse(String reqId) {
        DeviceManagerEventResponse dmeo = new DeviceManagerEventResponse();
        dmeo.setRequestId(reqId);
        Return ret = new Return();
        ret.setValue("Success");
        ret.setFailureReason("Success");
        dmeo.setReturn(ret);
        return dmeo;
    }
}

