/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.handler;

import in.gov.uidai.dm.handler.AppEntity;
import in.gov.uidai.dm.handler.VDMEntity;
import in.gov.uidai.dm.proc.IHandlerContext;
import in.gov.uidai.dm.xml.Arrival;
import in.gov.uidai.dm.xml.DeviceManagerEventRequest;
import in.gov.uidai.dm.xml.Removal;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VDMBroadcast {
    private static final Logger LOGGER = LoggerFactory.getLogger(VDMBroadcast.class);
    private static final int SCHEDULE_DELAY = 100;
    private static final VDMBroadcast THE_INST = new VDMBroadcast();
    private final Timer bcastTimer = new Timer(true);

    public static VDMBroadcast getInst() {
        return THE_INST;
    }

    private VDMBroadcast() {
    }

    public void clientArrived(AppEntity appEnt) {
        ClientBoardingTask task = new ClientBoardingTask(appEnt);
        this.bcastTimer.schedule((TimerTask)task, 100L);
    }

    public void deviceArrived(Arrival arrival) {
        DeviceArrivalTask task = new DeviceArrivalTask(arrival);
        this.bcastTimer.schedule((TimerTask)task, 100L);
    }

    public void deviceRemoved(Removal removal) {
        DeviceRemovalTask task = new DeviceRemovalTask(removal);
        this.bcastTimer.schedule((TimerTask)task, 100L);
    }

    private void fireDeviceArrived(Arrival arrival) {
        DeviceManagerEventRequest dmer = new DeviceManagerEventRequest();
        UUID reqId = UUID.randomUUID();
        dmer.setRequestId(((Object)reqId).toString());
        dmer.setArrival(arrival);
        Iterator<AppEntity> iter = AppEntity.listAll().iterator();
        while (iter.hasNext()) {
            this.writeRequest(iter.next(), dmer);
        }
    }

    private void fireDeviceRemoved(Removal removal) {
        DeviceManagerEventRequest dmer = new DeviceManagerEventRequest();
        UUID reqId = UUID.randomUUID();
        dmer.setRequestId(((Object)reqId).toString());
        dmer.setRemoval(removal);
        Iterator<AppEntity> iter = AppEntity.listAll().iterator();
        while (iter.hasNext()) {
            this.writeRequest(iter.next(), dmer);
        }
    }

    private void onboardClient(AppEntity appEnt) {
        Iterator<VDMEntity> iter = VDMEntity.listAll().iterator();
        DeviceManagerEventRequest dmer = new DeviceManagerEventRequest();
        while (iter.hasNext()) {
            VDMEntity vdmEnt = iter.next();
            for (Arrival arrival : vdmEnt.getDevices()) {
                dmer.setRequestId(UUID.randomUUID().toString());
                dmer.setArrival(arrival);
                this.writeRequest(appEnt, dmer);
            }
        }
    }

    private void writeRequest(AppEntity appEnt, Object request) {
        IHandlerContext hCtxt = appEnt.getHandlerContext();
        if (hCtxt == null) {
            return;
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Marshaller marshal = JAXBContext.newInstance((Class[])new Class[]{request.getClass()}).createMarshaller();
            marshal.setProperty("jaxb.fragment", (Object)true);
            if (LOGGER.isDebugEnabled()) {
                ByteArrayOutputStream logBuf = new ByteArrayOutputStream();
                marshal.setProperty("jaxb.formatted.output", (Object)true);
                marshal.marshal(request, (OutputStream)logBuf);
                LOGGER.debug("=== Outgoing Request Start ===");
                LOGGER.debug("\n" + logBuf.toString());
                LOGGER.debug("=== Outgoing Request End ===");
            }
            marshal.setProperty("jaxb.formatted.output", (Object)false);
            marshal.marshal(request, (OutputStream)output);
            output.flush();
            output.close();
            hCtxt.writeResponse(output.toByteArray());
            LOGGER.debug("request sent");
        }
        catch (Exception exep) {
            LOGGER.warn("write to socket failed", (Throwable)exep);
            try {
                hCtxt.closeConnection();
            }
            catch (Exception exep1) {
                LOGGER.warn("closing of socket failed", (Throwable)exep1);
            }
            appEnt.remove();
        }
    }

    private class ClientBoardingTask
    extends TimerTask {
        private final AppEntity appEnt;

        ClientBoardingTask(AppEntity ent) {
            this.appEnt = ent;
        }

        @Override
        public void run() {
            VDMBroadcast.this.onboardClient(this.appEnt);
        }
    }

    private class DeviceRemovalTask
    extends TimerTask {
        private final Removal removal;

        DeviceRemovalTask(Removal rmv) {
            this.removal = rmv;
        }

        @Override
        public void run() {
            VDMBroadcast.this.fireDeviceRemoved(this.removal);
        }
    }

    private class DeviceArrivalTask
    extends TimerTask {
        private final Arrival arrival;

        DeviceArrivalTask(Arrival arrv) {
            this.arrival = arrv;
        }

        @Override
        public void run() {
            VDMBroadcast.this.fireDeviceArrived(this.arrival);
        }
    }
}

