/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.handler;

import in.gov.uidai.dm.handler.VDMBroadcast;
import in.gov.uidai.dm.manage.DesktopNotification;
import in.gov.uidai.dm.xml.Arrival;
import in.gov.uidai.dm.xml.Removal;
import in.gov.uidai.dm.xml.VDM;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VDMEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(VDMEntity.class);
    private static final Map<String, VDMEntity> ENTITY_MAP = new HashMap<String, VDMEntity>();
    private static final Timer HB_TIMER = new Timer("VDM Timeout Timer", true);
    private final String entityName;
    private final String connectionId;
    private VDM vdm;
    private final Map<String, Arrival> arrivalMap;
    private TimerTask pingTimeoutTask;

    public static final Collection<VDMEntity> listAll() {
        return ENTITY_MAP.values();
    }

    public static final VDMEntity get(String vdmName) {
        return ENTITY_MAP.get(vdmName);
    }

    public static final VDMEntity getByConnectionId(String connId) {
        for (VDMEntity entity : ENTITY_MAP.values()) {
            if (!StringUtils.equalsIgnoreCase((String)connId, (String)entity.connectionId)) continue;
            return entity;
        }
        return null;
    }

    public VDMEntity(String name, String connId) {
        this.entityName = name;
        this.connectionId = connId;
        this.arrivalMap = new HashMap<String, Arrival>();
        ENTITY_MAP.put(this.entityName, this);
        LOGGER.debug("VDM added [" + this.entityName + "]");
    }

    public void waitForPing(long timeout) {
        if (this.pingTimeoutTask != null) {
            this.pingTimeoutTask.cancel();
            HB_TIMER.purge();
        }
        this.pingTimeoutTask = new TimerTask(){

            @Override
            public void run() {
                LOGGER.debug("heartbeat timeout [" + VDMEntity.this.entityName + "]");
                VDMEntity.this.remove();
            }
        };
        HB_TIMER.schedule(this.pingTimeoutTask, TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS));
        LOGGER.debug("Heartbeat for [" + this.entityName + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        VDMEntity vDMEntity = this;
        synchronized (vDMEntity) {
            if (this.pingTimeoutTask != null) {
                this.pingTimeoutTask.cancel();
                HB_TIMER.purge();
            }
            ENTITY_MAP.remove(this.entityName);
            LOGGER.debug("VDM removed [" + this.entityName + "]");
            Iterator<Arrival> arrivals = this.arrivalMap.values().iterator();
            Removal removal = new Removal();
            while (arrivals.hasNext()) {
                Arrival arrival = arrivals.next();
                DesktopNotification.getInst().showMessage("Device removed " + arrival);
                removal.setDeviceURI(arrival.getDeviceURI());
                VDMBroadcast.getInst().deviceRemoved(removal);
            }
        }
    }

    public Collection<Arrival> getDevices() {
        return this.arrivalMap.values();
    }

    public void addDevice(Arrival arrival) {
        this.arrivalMap.put(arrival.getDeviceURI(), arrival);
    }

    public Arrival removeDevice(Removal removal) {
        return this.arrivalMap.remove(removal.getDeviceURI());
    }

    public VDM getVDM() {
        return this.vdm;
    }

    public void setVDM(VDM value) {
        this.vdm = value;
    }
}

