/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.manage;

import java.io.IOException;
import java.io.InputStream;

public class DebugInputStream
extends InputStream {
    private final InputStream source;
    private final StringBuffer debugBuffer;

    public DebugInputStream(InputStream src) {
        this.source = src;
        this.debugBuffer = new StringBuffer();
    }

    @Override
    public int read() throws IOException {
        int result = this.source.read();
        this.debugBuffer.append((char)result);
        return result;
    }

    @Override
    public int read(byte[] buffer, int start, int length) throws IOException {
        int amt = this.source.read(buffer, start, length);
        this.debugBuffer.append(new String(buffer, 0, amt));
        return amt;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public String debugAndClear() {
        String result = this.debugBuffer.toString();
        this.debugBuffer.delete(0, this.debugBuffer.length());
        return result;
    }
}

