/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.manage;

import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DesktopNotification {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesktopNotification.class);
    private static final DesktopNotification THE_INST = new DesktopNotification();
    private TrayIcon tray;

    public static DesktopNotification getInst() {
        return THE_INST;
    }

    private DesktopNotification() {
        ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("res/dm/tray_icon.png"));
        if (GraphicsEnvironment.isHeadless()) {
            LOGGER.warn("headless graphics environment. Cannot access system tray");
            return;
        }
        if (!SystemTray.isSupported()) {
            LOGGER.warn("system tray not supported.");
            return;
        }
        this.tray = new TrayIcon(icon.getImage());
        this.tray.setImageAutoSize(true);
        SystemTray sysTray = SystemTray.getSystemTray();
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.addActionListener(new ExitHandler());
        PopupMenu popup = new PopupMenu();
        popup.add(exitItem);
        this.tray.setPopupMenu(popup);
        try {
            sysTray.add(this.tray);
        }
        catch (AWTException exep) {
            LOGGER.warn("system tray not available.", (Throwable)exep);
        }
    }

    public void showMessage(String message) {
        if (this.tray == null) {
            return;
        }
        this.tray.displayMessage("Aadhaar Device Manager", message, TrayIcon.MessageType.NONE);
    }

    private static class ExitHandler
    implements ActionListener {
        private ExitHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            System.exit(0);
        }
    }
}

