/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.manage;

import in.gov.uidai.dm.manage.IThreadPoolExecutorMonitor;
import java.lang.management.ManagementFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolExecutorMonitor
implements IThreadPoolExecutorMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolExecutorMonitor.class);
    private static final String JMX_NAME = "aadhaar:type=" + IThreadPoolExecutorMonitor.class.getName();
    private final ThreadPoolExecutor executor;

    public static void manage(ThreadPoolExecutor executor) {
        try {
            new ThreadPoolExecutorMonitor(executor);
        }
        catch (JMException exep) {
            LOGGER.error("jmx setup failed", (Throwable)exep);
        }
    }

    private ThreadPoolExecutorMonitor(ThreadPoolExecutor exec) throws NotCompliantMBeanException, MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException {
        this.executor = exec;
        StandardMBean smb = new StandardMBean(this, IThreadPoolExecutorMonitor.class);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName(JMX_NAME);
        mbs.registerMBean(smb, name);
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    @Override
    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    @Override
    public long getTaskCount() {
        return this.executor.getTaskCount();
    }

    @Override
    public int getQueueSize() {
        BlockingQueue<Runnable> queue = this.executor.getQueue();
        if (queue == null) {
            return 0;
        }
        return queue.size();
    }
}

