/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.net;

import in.gov.uidai.dm.net.HandlerContext;
import in.gov.uidai.dm.proc.IXmlInputListener;
import in.gov.uidai.dm.proc.RequestHandler;
import in.gov.uidai.dm.proc.XmlInputReader;
import in.gov.uidai.dm.xml.APP;
import in.gov.uidai.dm.xml.Arrival;
import in.gov.uidai.dm.xml.Capabilities;
import in.gov.uidai.dm.xml.ClientCommandRequest;
import in.gov.uidai.dm.xml.Connect;
import in.gov.uidai.dm.xml.DeviceManagerEventRequest;
import in.gov.uidai.dm.xml.FrameType;
import in.gov.uidai.dm.xml.Ping;
import in.gov.uidai.dm.xml.Removal;
import in.gov.uidai.dm.xml.SampleFormat;
import in.gov.uidai.dm.xml.SampleFormats;
import in.gov.uidai.dm.xml.VDM;
import in.gov.uidai.dm.xml.VideoFormat;
import in.gov.uidai.dm.xml.VideoFormats;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
implements Runnable,
IXmlInputListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final String connectionId;
    private final Socket sock;
    private final XmlInputReader xread;
    private OutputStream output;
    private final Configuration config;

    Connection(Socket socket, Configuration cfg) {
        LOGGER.debug("new connection received");
        this.connectionId = UUID.randomUUID().toString();
        this.sock = socket;
        this.config = cfg;
        this.xread = new XmlInputReader();
        this.xread.addListener(this);
        this.xread.addBoundaryTag("DeviceManagerEventRequest");
        this.xread.addBoundaryTag("DeviceManagerEventResponse");
        this.xread.addBoundaryTag("ClientCommandRequest");
        this.xread.addBoundaryTag("ClientCommandResponse");
        this.xread.addObjectCreate("DeviceManagerEventRequest", DeviceManagerEventRequest.class);
        this.xread.addSetProperties("DeviceManagerEventRequest");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Arrival", Arrival.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Arrival");
        this.xread.addSetNext("DeviceManagerEventRequest/Arrival", "setArrival");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities", Capabilities.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Arrival/Capabilities");
        this.xread.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities", "setCapabilities");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats", VideoFormats.class);
        this.xread.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats", "setVideoFormats");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat", VideoFormat.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat");
        this.xread.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat", "addVideoFormat");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType", FrameType.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType");
        this.xread.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType", "setFrameType");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities/SampleFormats", SampleFormats.class);
        this.xread.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities/SampleFormats", "setSampleFormats");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities/SampleFormats/SampleFormat", SampleFormat.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Arrival/Capabilities/SampleFormats/SampleFormat");
        this.xread.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities/SampleFormats/SampleFormat", "addSampleFormat");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Removal", Removal.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Removal");
        this.xread.addSetNext("DeviceManagerEventRequest/Removal", "setRemoval");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Connect", Connect.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Connect");
        this.xread.addSetNext("DeviceManagerEventRequest/Connect", "setConnect");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Connect/VDM", VDM.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Connect/VDM");
        this.xread.addSetNext("DeviceManagerEventRequest/Connect/VDM", "setVDM");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Connect/APP", APP.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Connect/APP");
        this.xread.addSetNext("DeviceManagerEventRequest/Connect/APP", "setAPP");
        this.xread.addObjectCreate("DeviceManagerEventRequest/Ping", Ping.class);
        this.xread.addSetProperties("DeviceManagerEventRequest/Ping");
        this.xread.addSetNext("DeviceManagerEventRequest/Ping", "setPing");
        this.xread.addObjectCreate("ClientCommandRequest", ClientCommandRequest.class);
        this.xread.addSetProperties("ClientCommandRequest");
    }

    @Override
    public void run() {
        try {
            InputStream input = this.sock.getInputStream();
            this.output = this.sock.getOutputStream();
            this.xread.parse(input);
        }
        catch (Exception exep) {
            LOGGER.debug("finished reading from stream");
            try {
                this.sock.close();
            }
            catch (IOException ioe) {
                LOGGER.debug("error closing socket", (Throwable)ioe);
            }
            RequestHandler.getInst().connectionClosed(this.connectionId);
        }
    }

    @Override
    public void onDocumentReceived(Object doc) {
        HandlerContext ctxt = new HandlerContext(this.connectionId, doc, this.output, this.sock, this.config);
        RequestHandler.getInst().execute(ctxt);
    }
}

