/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.net;

import in.gov.uidai.dm.manage.DesktopNotification;
import in.gov.uidai.dm.manage.ThreadPoolExecutorMonitor;
import in.gov.uidai.dm.net.Connection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketServer.class);
    private Thread mainThrd;
    private boolean runFlag;
    private ExecutorService executor;
    private final Configuration config;

    public SocketServer(Configuration cfg) {
        this.config = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.stop();
        LOGGER.trace("wait a while");
        int startupDelay = this.config.getInt("startup.delay", 3);
        try {
            SocketServer socketServer = this;
            synchronized (socketServer) {
                this.wait(TimeUnit.MILLISECONDS.convert(startupDelay, TimeUnit.SECONDS));
            }
        }
        catch (InterruptedException exep) {
            return;
        }
        int maxConnections = this.config.getInt("connections.max", 10);
        LOGGER.trace("maximum concurrent connections: " + maxConnections);
        this.executor = new ThreadPoolExecutor(maxConnections, maxConnections, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxConnections * 100));
        try {
            ThreadPoolExecutorMonitor.manage((ThreadPoolExecutor)this.executor);
        }
        catch (Exception exep) {
            LOGGER.warn("error setting up jmx", (Throwable)exep);
        }
        this.runFlag = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SocketServer.this.execute();
            }
        };
        this.mainThrd = new Thread(runnable, "DM Server");
        this.mainThrd.start();
    }

    public void stop() {
        this.runFlag = false;
        if (this.mainThrd != null && this.mainThrd.isAlive()) {
            this.mainThrd.interrupt();
        }
        this.mainThrd = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
    }

    private void execute() {
        String bindHost = this.config.getString("bind.host", "*");
        int minPort = this.config.getInt("bind.port.min", 4401);
        int maxPort = this.config.getInt("bind.port.max", 4410);
        LOGGER.info("ready to iterate between ports " + minPort + " and " + maxPort);
        ServerSocket srvSock = null;
        for (int port = minPort; port < maxPort; ++port) {
            try {
                InetSocketAddress bindAddr = new InetSocketAddress(bindHost, port);
                srvSock = new ServerSocket();
                srvSock.bind(bindAddr, 50);
                srvSock.setSoTimeout(5000);
                srvSock.setReuseAddress(true);
                LOGGER.info("server bound to " + bindHost + ":" + port);
                break;
            }
            catch (IOException exep) {
                srvSock = null;
                LOGGER.trace("unable to connect on port " + port);
                continue;
            }
        }
        if (srvSock == null) {
            LOGGER.error("server failed to start. All ports in use");
            return;
        }
        LOGGER.info("connected on port " + srvSock.getLocalPort());
        DesktopNotification.getInst().showMessage("connected on " + bindHost + ":" + srvSock.getLocalPort());
        while (this.runFlag) {
            try {
                Socket sock = srvSock.accept();
                sock.setReuseAddress(true);
                Connection conn = new Connection(sock, this.config);
                this.executor.submit(conn);
            }
            catch (SocketTimeoutException sock) {
            }
            catch (IOException exep) {
                LOGGER.error("connection refused", (Throwable)exep);
                break;
            }
        }
        this.runFlag = false;
    }
}

