/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.dm.proc;

import in.gov.uidai.dm.manage.DebugInputStream;
import in.gov.uidai.dm.proc.IXmlInputListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlInputReader
extends Digester {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlInputReader.class);
    private final List<String> boundaryList = new ArrayList<String>();
    private DebugInputStream debugIn;
    private final List<IXmlInputListener> listeners = new ArrayList<IXmlInputListener>();

    public void addBoundaryTag(String tag) {
        this.boundaryList.add(tag);
    }

    public void addListener(IXmlInputListener xil) {
        if (!this.listeners.contains(xil)) {
            this.listeners.add(xil);
        }
    }

    public void removeListener(IXmlInputListener xil) {
        this.listeners.remove(xil);
    }

    public void addObjectCreate(String pattern, Class cls) {
        super.addObjectCreate("root/" + pattern, cls);
    }

    public void addSetProperties(String pattern) {
        super.addSetProperties("root/" + pattern);
    }

    public void addSetNext(String pattern, String methodName) {
        super.addSetNext("root/" + pattern, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(InputStream input) throws IOException, SAXException {
        ByteArrayInputStream ris = new ByteArrayInputStream("<root>".getBytes());
        SequenceInputStream sis = new SequenceInputStream(ris, input);
        this.debugIn = new DebugInputStream(sis);
        try {
            Object object = super.parse((InputStream)this.debugIn);
            return object;
        }
        finally {
            this.logResponse();
        }
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
        if (!this.boundaryList.contains(name)) {
            super.endElement(namespaceURI, localName, name);
            return;
        }
        this.logResponse();
        Object top = this.peek();
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onDocumentReceived(top);
                continue;
            }
            catch (Exception exep) {
                LOGGER.error("while firing document received event", (Throwable)exep);
            }
        }
        super.endElement(namespaceURI, localName, name);
    }

    private void logResponse() {
        if (LOGGER.isDebugEnabled() && this.debugIn != null) {
            LOGGER.debug("");
            LOGGER.debug("=== Incoming Request Start ===");
            LOGGER.debug(this.debugIn.debugAndClear());
            LOGGER.debug("=== Incoming Request End ===");
            LOGGER.debug("");
        }
    }
}

