/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.util.ArrayList;

public final class AddressBookAUResultParser
extends ResultParser {
    @Override
    public AddressBookParsedResult parse(Result result) {
        String[] stringArray;
        String rawText = result.getText();
        if (!rawText.contains("MEMORY") || !rawText.contains("\r\n")) {
            return null;
        }
        String name = AddressBookAUResultParser.matchSinglePrefixedField("NAME1:", rawText, '\r', true);
        String pronunciation = AddressBookAUResultParser.matchSinglePrefixedField("NAME2:", rawText, '\r', true);
        String[] phoneNumbers = AddressBookAUResultParser.matchMultipleValuePrefix("TEL", 3, rawText, true);
        String[] emails = AddressBookAUResultParser.matchMultipleValuePrefix("MAIL", 3, rawText, true);
        String note = AddressBookAUResultParser.matchSinglePrefixedField("MEMORY:", rawText, '\r', false);
        String address = AddressBookAUResultParser.matchSinglePrefixedField("ADD:", rawText, '\r', true);
        if (address == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = address;
        }
        String[] addresses = stringArray;
        return new AddressBookParsedResult(AddressBookAUResultParser.maybeWrap(name), pronunciation, phoneNumbers, null, emails, null, null, note, addresses, null, null, null, null, null);
    }

    private static String[] matchMultipleValuePrefix(String prefix, int max, String rawText, boolean trim) {
        ArrayList<String> values = null;
        int i = 1;
        while (i <= max) {
            String value = AddressBookAUResultParser.matchSinglePrefixedField(String.valueOf(prefix) + i + ':', rawText, '\r', trim);
            if (value == null) break;
            if (values == null) {
                values = new ArrayList<String>(max);
            }
            values.add(value);
            ++i;
        }
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }
}

