/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Map;

public final class ITFWriter
extends UPCEANWriter {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        if (format != BarcodeFormat.ITF) {
            throw new IllegalArgumentException("Can only encode ITF, but got " + (Object)((Object)format));
        }
        return super.encode(contents, format, width, height, hints);
    }

    @Override
    public byte[] encode(String contents) {
        int length = contents.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("The lenght of the input should be even");
        }
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length);
        }
        byte[] result = new byte[9 + 9 * length];
        int[] start = new int[]{1, 1, 1, 1};
        int pos = ITFWriter.appendPattern(result, 0, start, 1);
        int i = 0;
        while (i < length) {
            int one = Character.digit(contents.charAt(i), 10);
            int two = Character.digit(contents.charAt(i + 1), 10);
            int[] encoding = new int[18];
            int j = 0;
            while (j < 5) {
                encoding[j << 1] = ITFReader.PATTERNS[one][j];
                encoding[(j << 1) + 1] = ITFReader.PATTERNS[two][j];
                ++j;
            }
            pos += ITFWriter.appendPattern(result, pos, encoding, 1);
            i += 2;
        }
        int[] end = new int[]{3, 1, 1};
        pos += ITFWriter.appendPattern(result, pos, end, 1);
        return result;
    }
}

