/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss;

import com.google.zxing.NotFoundException;
import com.google.zxing.oned.OneDReader;

public abstract class AbstractRSSReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 51;
    private static final int MAX_INDIVIDUAL_VARIANCE = 102;
    private static final float MIN_FINDER_PATTERN_RATIO = 0.7916667f;
    private static final float MAX_FINDER_PATTERN_RATIO = 0.89285713f;
    private final int[] decodeFinderCounters = new int[4];
    private final int[] dataCharacterCounters = new int[8];
    private final float[] oddRoundingErrors = new float[4];
    private final float[] evenRoundingErrors = new float[4];
    private final int[] oddCounts = new int[this.dataCharacterCounters.length / 2];
    private final int[] evenCounts = new int[this.dataCharacterCounters.length / 2];

    protected AbstractRSSReader() {
    }

    protected int[] getDecodeFinderCounters() {
        return this.decodeFinderCounters;
    }

    protected int[] getDataCharacterCounters() {
        return this.dataCharacterCounters;
    }

    protected float[] getOddRoundingErrors() {
        return this.oddRoundingErrors;
    }

    protected float[] getEvenRoundingErrors() {
        return this.evenRoundingErrors;
    }

    protected int[] getOddCounts() {
        return this.oddCounts;
    }

    protected int[] getEvenCounts() {
        return this.evenCounts;
    }

    protected static int parseFinderValue(int[] counters, int[][] finderPatterns) throws NotFoundException {
        int value = 0;
        while (value < finderPatterns.length) {
            if (AbstractRSSReader.patternMatchVariance(counters, finderPatterns[value], 102) < 51) {
                return value;
            }
            ++value;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static int count(int[] array) {
        int count = 0;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            count += a;
            ++n2;
        }
        return count;
    }

    protected static void increment(int[] array, float[] errors) {
        int index = 0;
        float biggestError = errors[0];
        int i = 1;
        while (i < array.length) {
            if (errors[i] > biggestError) {
                biggestError = errors[i];
                index = i;
            }
            ++i;
        }
        int n = index;
        array[n] = array[n] + 1;
    }

    protected static void decrement(int[] array, float[] errors) {
        int index = 0;
        float biggestError = errors[0];
        int i = 1;
        while (i < array.length) {
            if (errors[i] < biggestError) {
                biggestError = errors[i];
                index = i;
            }
            ++i;
        }
        int n = index;
        array[n] = array[n] - 1;
    }

    protected static boolean isFinderPattern(int[] counters) {
        int firstTwoSum = counters[0] + counters[1];
        int sum = firstTwoSum + counters[2] + counters[3];
        float ratio = (float)firstTwoSum / (float)sum;
        if (ratio >= 0.7916667f && ratio <= 0.89285713f) {
            int minCounter = Integer.MAX_VALUE;
            int maxCounter = Integer.MIN_VALUE;
            int[] nArray = counters;
            int n = counters.length;
            int n2 = 0;
            while (n2 < n) {
                int counter = nArray[n2];
                if (counter > maxCounter) {
                    maxCounter = counter;
                }
                if (counter < minCounter) {
                    minCounter = counter;
                }
                ++n2;
            }
            return maxCounter < 10 * minCounter;
        }
        return false;
    }
}

