/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.BlockPair;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.MaskUtil;
import com.google.zxing.qrcode.encoder.MatrixUtil;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE;
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    static {
        int[] nArray = new int[96];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        nArray[14] = -1;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = -1;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[23] = -1;
        nArray[24] = -1;
        nArray[25] = -1;
        nArray[26] = -1;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = 36;
        nArray[33] = -1;
        nArray[34] = -1;
        nArray[35] = -1;
        nArray[36] = 37;
        nArray[37] = 38;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[40] = -1;
        nArray[41] = -1;
        nArray[42] = 39;
        nArray[43] = 40;
        nArray[44] = -1;
        nArray[45] = 41;
        nArray[46] = 42;
        nArray[47] = 43;
        nArray[49] = 1;
        nArray[50] = 2;
        nArray[51] = 3;
        nArray[52] = 4;
        nArray[53] = 5;
        nArray[54] = 6;
        nArray[55] = 7;
        nArray[56] = 8;
        nArray[57] = 9;
        nArray[58] = 44;
        nArray[59] = -1;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        nArray[64] = -1;
        nArray[65] = 10;
        nArray[66] = 11;
        nArray[67] = 12;
        nArray[68] = 13;
        nArray[69] = 14;
        nArray[70] = 15;
        nArray[71] = 16;
        nArray[72] = 17;
        nArray[73] = 18;
        nArray[74] = 19;
        nArray[75] = 20;
        nArray[76] = 21;
        nArray[77] = 22;
        nArray[78] = 23;
        nArray[79] = 24;
        nArray[80] = 25;
        nArray[81] = 26;
        nArray[82] = 27;
        nArray[83] = 28;
        nArray[84] = 29;
        nArray[85] = 30;
        nArray[86] = 31;
        nArray[87] = 32;
        nArray[88] = 33;
        nArray[89] = 34;
        nArray[90] = 35;
        nArray[91] = -1;
        nArray[92] = -1;
        nArray[93] = -1;
        nArray[94] = -1;
        nArray[95] = -1;
        ALPHANUMERIC_TABLE = nArray;
    }

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix matrix) {
        int penalty = 0;
        penalty += MaskUtil.applyMaskPenaltyRule1(matrix);
        penalty += MaskUtil.applyMaskPenaltyRule2(matrix);
        penalty += MaskUtil.applyMaskPenaltyRule3(matrix);
        return penalty += MaskUtil.applyMaskPenaltyRule4(matrix);
    }

    public static void encode(String content, ErrorCorrectionLevel ecLevel, QRCode qrCode) throws WriterException {
        Encoder.encode(content, ecLevel, null, qrCode);
    }

    public static void encode(String content, ErrorCorrectionLevel ecLevel, Map<EncodeHintType, ?> hints, QRCode qrCode) throws WriterException {
        CharacterSetECI eci;
        String encoding;
        String string = encoding = hints == null ? null : (String)hints.get((Object)EncodeHintType.CHARACTER_SET);
        if (encoding == null) {
            encoding = DEFAULT_BYTE_MODE_ENCODING;
        }
        Mode mode = Encoder.chooseMode(content, encoding);
        BitArray dataBits = new BitArray();
        Encoder.appendBytes(content, mode, dataBits, encoding);
        int numInputBits = dataBits.getSize();
        Encoder.initQRCode(numInputBits, ecLevel, mode, qrCode);
        BitArray headerAndDataBits = new BitArray();
        if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(encoding) && (eci = CharacterSetECI.getCharacterSetECIByName(encoding)) != null) {
            Encoder.appendECI(eci, headerAndDataBits);
        }
        Encoder.appendModeInfo(mode, headerAndDataBits);
        int numLetters = mode == Mode.BYTE ? dataBits.getSizeInBytes() : content.length();
        Encoder.appendLengthInfo(numLetters, qrCode.getVersion(), mode, headerAndDataBits);
        headerAndDataBits.appendBitArray(dataBits);
        Encoder.terminateBits(qrCode.getNumDataBytes(), headerAndDataBits);
        BitArray finalBits = new BitArray();
        Encoder.interleaveWithECBytes(headerAndDataBits, qrCode.getNumTotalBytes(), qrCode.getNumDataBytes(), qrCode.getNumRSBlocks(), finalBits);
        ByteMatrix matrix = new ByteMatrix(qrCode.getMatrixWidth(), qrCode.getMatrixWidth());
        qrCode.setMaskPattern(Encoder.chooseMaskPattern(finalBits, ecLevel, qrCode.getVersion(), matrix));
        MatrixUtil.buildMatrix(finalBits, ecLevel, qrCode.getVersion(), qrCode.getMaskPattern(), matrix);
        qrCode.setMatrix(matrix);
        if (!qrCode.isValid()) {
            throw new WriterException("Invalid QR code: " + qrCode.toString());
        }
    }

    static int getAlphanumericCode(int code) {
        if (code < ALPHANUMERIC_TABLE.length) {
            return ALPHANUMERIC_TABLE[code];
        }
        return -1;
    }

    public static Mode chooseMode(String content) {
        return Encoder.chooseMode(content, null);
    }

    private static Mode chooseMode(String content, String encoding) {
        if ("Shift_JIS".equals(encoding)) {
            return Encoder.isOnlyDoubleByteKanji(content) ? Mode.KANJI : Mode.BYTE;
        }
        boolean hasNumeric = false;
        boolean hasAlphanumeric = false;
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            if (c >= '0' && c <= '9') {
                hasNumeric = true;
            } else if (Encoder.getAlphanumericCode(c) != -1) {
                hasAlphanumeric = true;
            } else {
                return Mode.BYTE;
            }
            ++i;
        }
        if (hasAlphanumeric) {
            return Mode.ALPHANUMERIC;
        }
        if (hasNumeric) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String content) {
        byte[] bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
        int length = bytes.length;
        if (length % 2 != 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            int byte1 = bytes[i] & 0xFF;
            if (!(byte1 >= 129 && byte1 <= 159 || byte1 >= 224 && byte1 <= 235)) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bits, ErrorCorrectionLevel ecLevel, int version, ByteMatrix matrix) throws WriterException {
        int minPenalty = Integer.MAX_VALUE;
        int bestMaskPattern = -1;
        int maskPattern = 0;
        while (maskPattern < 8) {
            MatrixUtil.buildMatrix(bits, ecLevel, version, maskPattern, matrix);
            int penalty = Encoder.calculateMaskPenalty(matrix);
            if (penalty < minPenalty) {
                minPenalty = penalty;
                bestMaskPattern = maskPattern;
            }
            ++maskPattern;
        }
        return bestMaskPattern;
    }

    private static void initQRCode(int numInputBits, ErrorCorrectionLevel ecLevel, Mode mode, QRCode qrCode) throws WriterException {
        qrCode.setECLevel(ecLevel);
        qrCode.setMode(mode);
        int versionNum = 1;
        while (versionNum <= 40) {
            Version version = Version.getVersionForNumber(versionNum);
            int numBytes = version.getTotalCodewords();
            Version.ECBlocks ecBlocks = version.getECBlocksForLevel(ecLevel);
            int numEcBytes = ecBlocks.getTotalECCodewords();
            int numRSBlocks = ecBlocks.getNumBlocks();
            int numDataBytes = numBytes - numEcBytes;
            if (numDataBytes >= Encoder.getTotalInputBytes(numInputBits, version, mode)) {
                qrCode.setVersion(versionNum);
                qrCode.setNumTotalBytes(numBytes);
                qrCode.setNumDataBytes(numDataBytes);
                qrCode.setNumRSBlocks(numRSBlocks);
                qrCode.setNumECBytes(numEcBytes);
                qrCode.setMatrixWidth(version.getDimensionForVersion());
                return;
            }
            ++versionNum;
        }
        throw new WriterException("Cannot find proper rs block info (input data too big?)");
    }

    private static int getTotalInputBytes(int numInputBits, Version version, Mode mode) {
        int modeInfoBits = 4;
        int charCountBits = mode.getCharacterCountBits(version);
        int headerBits = modeInfoBits + charCountBits;
        int totalBits = numInputBits + headerBits;
        return (totalBits + 7) / 8;
    }

    static void terminateBits(int numDataBytes, BitArray bits) throws WriterException {
        int capacity = numDataBytes << 3;
        if (bits.getSize() > capacity) {
            throw new WriterException("data bits cannot fit in the QR Code" + bits.getSize() + " > " + capacity);
        }
        int i = 0;
        while (i < 4 && bits.getSize() < capacity) {
            bits.appendBit(false);
            ++i;
        }
        int numBitsInLastByte = bits.getSize() & 7;
        if (numBitsInLastByte > 0) {
            int i2 = numBitsInLastByte;
            while (i2 < 8) {
                bits.appendBit(false);
                ++i2;
            }
        }
        int numPaddingBytes = numDataBytes - bits.getSizeInBytes();
        int i3 = 0;
        while (i3 < numPaddingBytes) {
            bits.appendBits((i3 & 1) == 0 ? 236 : 17, 8);
            ++i3;
        }
        if (bits.getSize() != capacity) {
            throw new WriterException("Bits size does not equal capacity");
        }
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int numTotalBytes, int numDataBytes, int numRSBlocks, int blockID, int[] numDataBytesInBlock, int[] numECBytesInBlock) throws WriterException {
        if (blockID >= numRSBlocks) {
            throw new WriterException("Block ID too large");
        }
        int numRsBlocksInGroup2 = numTotalBytes % numRSBlocks;
        int numRsBlocksInGroup1 = numRSBlocks - numRsBlocksInGroup2;
        int numTotalBytesInGroup1 = numTotalBytes / numRSBlocks;
        int numDataBytesInGroup1 = numDataBytes / numRSBlocks;
        int numEcBytesInGroup1 = numTotalBytesInGroup1 - numDataBytesInGroup1;
        int numTotalBytesInGroup2 = numTotalBytesInGroup1 + 1;
        int numDataBytesInGroup2 = numDataBytesInGroup1 + 1;
        int numEcBytesInGroup2 = numTotalBytesInGroup2 - numDataBytesInGroup2;
        if (numEcBytesInGroup1 != numEcBytesInGroup2) {
            throw new WriterException("EC bytes mismatch");
        }
        if (numRSBlocks != numRsBlocksInGroup1 + numRsBlocksInGroup2) {
            throw new WriterException("RS blocks mismatch");
        }
        if (numTotalBytes != (numDataBytesInGroup1 + numEcBytesInGroup1) * numRsBlocksInGroup1 + (numDataBytesInGroup2 + numEcBytesInGroup2) * numRsBlocksInGroup2) {
            throw new WriterException("Total bytes mismatch");
        }
        if (blockID < numRsBlocksInGroup1) {
            numDataBytesInBlock[0] = numDataBytesInGroup1;
            numECBytesInBlock[0] = numEcBytesInGroup1;
        } else {
            numDataBytesInBlock[0] = numDataBytesInGroup2;
            numECBytesInBlock[0] = numEcBytesInGroup2;
        }
    }

    static void interleaveWithECBytes(BitArray bits, int numTotalBytes, int numDataBytes, int numRSBlocks, BitArray result) throws WriterException {
        if (bits.getSizeInBytes() != numDataBytes) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        int dataBytesOffset = 0;
        int maxNumDataBytes = 0;
        int maxNumEcBytes = 0;
        ArrayList<BlockPair> blocks = new ArrayList<BlockPair>(numRSBlocks);
        int i = 0;
        while (i < numRSBlocks) {
            int[] numDataBytesInBlock = new int[1];
            int[] numEcBytesInBlock = new int[1];
            Encoder.getNumDataBytesAndNumECBytesForBlockID(numTotalBytes, numDataBytes, numRSBlocks, i, numDataBytesInBlock, numEcBytesInBlock);
            int size = numDataBytesInBlock[0];
            byte[] dataBytes = new byte[size];
            bits.toBytes(8 * dataBytesOffset, dataBytes, 0, size);
            byte[] ecBytes = Encoder.generateECBytes(dataBytes, numEcBytesInBlock[0]);
            blocks.add(new BlockPair(dataBytes, ecBytes));
            maxNumDataBytes = Math.max(maxNumDataBytes, size);
            maxNumEcBytes = Math.max(maxNumEcBytes, ecBytes.length);
            dataBytesOffset += numDataBytesInBlock[0];
            ++i;
        }
        if (numDataBytes != dataBytesOffset) {
            throw new WriterException("Data bytes does not match offset");
        }
        i = 0;
        while (i < maxNumDataBytes) {
            for (BlockPair block : blocks) {
                byte[] dataBytes = block.getDataBytes();
                if (i >= dataBytes.length) continue;
                result.appendBits(dataBytes[i], 8);
            }
            ++i;
        }
        i = 0;
        while (i < maxNumEcBytes) {
            for (BlockPair block : blocks) {
                byte[] ecBytes = block.getErrorCorrectionBytes();
                if (i >= ecBytes.length) continue;
                result.appendBits(ecBytes[i], 8);
            }
            ++i;
        }
        if (numTotalBytes != result.getSizeInBytes()) {
            throw new WriterException("Interleaving error: " + numTotalBytes + " and " + result.getSizeInBytes() + " differ.");
        }
    }

    static byte[] generateECBytes(byte[] dataBytes, int numEcBytesInBlock) {
        int numDataBytes = dataBytes.length;
        int[] toEncode = new int[numDataBytes + numEcBytesInBlock];
        int i = 0;
        while (i < numDataBytes) {
            toEncode[i] = dataBytes[i] & 0xFF;
            ++i;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(toEncode, numEcBytesInBlock);
        byte[] ecBytes = new byte[numEcBytesInBlock];
        int i2 = 0;
        while (i2 < numEcBytesInBlock) {
            ecBytes[i2] = (byte)toEncode[numDataBytes + i2];
            ++i2;
        }
        return ecBytes;
    }

    static void appendModeInfo(Mode mode, BitArray bits) {
        bits.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int numLetters, int version, Mode mode, BitArray bits) throws WriterException {
        int numBits = mode.getCharacterCountBits(Version.getVersionForNumber(version));
        if (numLetters > (1 << numBits) - 1) {
            throw new WriterException(String.valueOf(numLetters) + "is bigger than" + ((1 << numBits) - 1));
        }
        bits.appendBits(numLetters, numBits);
    }

    static void appendBytes(String content, Mode mode, BitArray bits, String encoding) throws WriterException {
        switch (mode) {
            case NUMERIC: {
                Encoder.appendNumericBytes(content, bits);
                break;
            }
            case ALPHANUMERIC: {
                Encoder.appendAlphanumericBytes(content, bits);
                break;
            }
            case BYTE: {
                Encoder.append8BitBytes(content, bits, encoding);
                break;
            }
            case KANJI: {
                Encoder.appendKanjiBytes(content, bits);
                break;
            }
            default: {
                throw new WriterException("Invalid mode: " + (Object)((Object)mode));
            }
        }
    }

    static void appendNumericBytes(CharSequence content, BitArray bits) {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int num2;
            int num1 = content.charAt(i) - 48;
            if (i + 2 < length) {
                num2 = content.charAt(i + 1) - 48;
                int num3 = content.charAt(i + 2) - 48;
                bits.appendBits(num1 * 100 + num2 * 10 + num3, 10);
                i += 3;
                continue;
            }
            if (i + 1 < length) {
                num2 = content.charAt(i + 1) - 48;
                bits.appendBits(num1 * 10 + num2, 7);
                i += 2;
                continue;
            }
            bits.appendBits(num1, 4);
            ++i;
        }
    }

    static void appendAlphanumericBytes(CharSequence content, BitArray bits) throws WriterException {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int code1 = Encoder.getAlphanumericCode(content.charAt(i));
            if (code1 == -1) {
                throw new WriterException();
            }
            if (i + 1 < length) {
                int code2 = Encoder.getAlphanumericCode(content.charAt(i + 1));
                if (code2 == -1) {
                    throw new WriterException();
                }
                bits.appendBits(code1 * 45 + code2, 11);
                i += 2;
                continue;
            }
            bits.appendBits(code1, 6);
            ++i;
        }
    }

    static void append8BitBytes(String content, BitArray bits, String encoding) throws WriterException {
        byte[] bytes;
        try {
            bytes = content.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException(uee.toString());
        }
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            bits.appendBits(b, 8);
            ++n2;
        }
    }

    static void appendKanjiBytes(String content, BitArray bits) throws WriterException {
        byte[] bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException(uee.toString());
        }
        int length = bytes.length;
        int i = 0;
        while (i < length) {
            int byte1 = bytes[i] & 0xFF;
            int byte2 = bytes[i + 1] & 0xFF;
            int code = byte1 << 8 | byte2;
            int subtracted = -1;
            if (code >= 33088 && code <= 40956) {
                subtracted = code - 33088;
            } else if (code >= 57408 && code <= 60351) {
                subtracted = code - 49472;
            }
            if (subtracted == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int encoded = (subtracted >> 8) * 192 + (subtracted & 0xFF);
            bits.appendBits(encoded, 13);
            i += 2;
        }
    }

    private static void appendECI(CharacterSetECI eci, BitArray bits) {
        bits.appendBits(Mode.ECI.getBits(), 4);
        bits.appendBits(eci.getValue(), 8);
    }
}

