/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl;

import in.gov.uidai.ec.service.receipt.IReceiptPrinter;
import in.gov.uidai.ec.service.receipt.PrintRequest;
import in.gov.uidai.swing.fontman.FontManager;
import java.awt.Font;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReceiptPrinter
implements IReceiptPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReceiptPrinter.class);
    private static final String LABEL_PATH_EN = "res/print/common/static-labels_en_in.xml";

    protected void updateVarMap(PrintRequest request) {
        Map varMap = request.getVarMap();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Properties enStaticLabels = new Properties();
        InputStream input = cl.getResourceAsStream(LABEL_PATH_EN);
        try {
            enStaticLabels.loadFromXML(input);
            input.close();
        }
        catch (Exception exep) {
            LOGGER.error("while loading static labels en_in", (Throwable)exep);
            return;
        }
        Set<String> propNames = enStaticLabels.stringPropertyNames();
        for (String name : propNames) {
            varMap.put(name, enStaticLabels.getProperty(name));
        }
        String localeStr = request.getLocale();
        if (StringUtils.isBlank((String)localeStr)) {
            return;
        }
        String propFilePath = "res/print/common/static-labels_" + localeStr.toLowerCase() + ".xml";
        Properties locStaticLabels = new Properties();
        InputStream input1 = cl.getResourceAsStream(propFilePath);
        try {
            locStaticLabels.loadFromXML(input1);
            input1.close();
        }
        catch (Exception exep) {
            LOGGER.error("while loading static labels", (Throwable)exep);
            return;
        }
        Set<String> locPropNames = locStaticLabels.stringPropertyNames();
        for (String name : locPropNames) {
            varMap.put(name, locStaticLabels.getProperty(name));
        }
        Font font = FontManager.getInst().getPrintFontForLocale(localeStr);
        if (font != null) {
            varMap.put("localeFont", font.getFamily());
        }
    }
}

