/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.encoder.Compaction;
import com.google.zxing.pdf417.encoder.PDF417Writer;
import in.gov.uidai.ec.service.receipt.IPDF417Generator;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDF417Generator
implements IPDF417Generator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDF417Generator.class);

    public BufferedImage generatePDF417(String data) {
        LOGGER.debug("Generating the barcode");
        LOGGER.debug("Encoded data " + data);
        BufferedImage image = null;
        String imageFormat = "png";
        String filename = "barcode." + imageFormat;
        String barcodeImgLoc = "data/" + filename;
        File imageFile = new File(barcodeImgLoc);
        int dpi = 300;
        try {
            BitMatrix bitMatrix = new PDF417Writer().encode(data, BarcodeFormat.PDF_417, false, 9, 5, 1, 9, 1, 5, Compaction.AUTO);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)imageFormat, (OutputStream)new FileOutputStream(imageFile));
            image = ImageIO.read(imageFile);
            if (image != null) {
                image = this.rotate(image, -90);
                this.saveImage(imageFile, image, imageFormat, dpi);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (WriterException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return image;
    }

    private BufferedImage rotate(BufferedImage image, int angle) throws Exception {
        BufferedImage rotatedImage = null;
        int width = image.getWidth();
        int height = image.getHeight();
        rotatedImage = new BufferedImage(height, width, image.getType());
        Graphics2D g = rotatedImage.createGraphics();
        g.rotate(Math.toRadians(angle), width / 2, width / 2);
        g.drawImage(image, null, 0, 0);
        return rotatedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImage(File output, BufferedImage image, String imageFormat, int dpi) throws IOException {
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(imageFormat);
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(12);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            this.setDPI(metadata, dpi);
            try (ImageOutputStream stream = ImageIO.createImageOutputStream(output);){
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                break;
            }
        }
    }

    private void setDPI(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)dpi / 10.0 / 2.54;
        IIOMetadataNode horizontal = new IIOMetadataNode("HorizontalPixelSize");
        horizontal.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vertical = new IIOMetadataNode("VerticalPixelSize");
        vertical.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dimension = new IIOMetadataNode("Dimension");
        dimension.appendChild(horizontal);
        dimension.appendChild(vertical);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dimension);
        metadata.mergeTree("javax_imageio_1.0", root);
    }
}

