/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl;

import in.gov.uidai.ec.icas.util.OS;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePrint {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplePrint.class);

    public boolean print(byte[] pdf) {
        try {
            boolean userClickedPrint;
            String jobName = "AADHAAR-RECEIPT-" + Long.toString(System.currentTimeMillis(), 36).toUpperCase();
            LOGGER.info("Performing print job: " + jobName);
            PDDocument document = PDDocument.load((byte[])pdf);
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPageable((Pageable)new PDFPageable(document));
            printerJob.setJobName(jobName);
            HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
            attr.add(MediaSizeName.ISO_A4);
            attr.add(OrientationRequested.PORTRAIT);
            if (OS.IsWindows()) {
                attr.add(new Copies(1));
            }
            if (userClickedPrint = printerJob.printDialog(attr)) {
                printerJob.print();
                return userClickedPrint;
            }
            printerJob.cancel();
            document.close();
        }
        catch (PrinterException | IOException e) {
            throw new RuntimeException("Exception occurred while printing", e);
        }
        return false;
    }
}

