/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.awt;

import in.gov.uidai.ec.print.impl.awt.RootElement;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXB;

public class AwtReceipt
implements Printable {
    private String tplPath;
    private Map<String, Object> varMap;

    public AwtReceipt(String tplPath, Map<String, Object> varMap) {
        this.tplPath = tplPath;
        this.varMap = varMap;
    }

    public byte[] printToFile() throws IOException {
        RootElement root = this.loadTemplate();
        double scale = 2.5;
        final JComponent canvas = root.toSwing(this.varMap, scale);
        BufferedImage bim1 = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 10);
        final Graphics2D bimg = bim1.createGraphics();
        bimg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        bimg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        bimg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bimg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                canvas.paint(bimg);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exep) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bim1, "PNG", bos);
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        RootElement root = this.loadTemplate();
        Dimension originalSize = root.getSize();
        Graphics2D prnG2D = (Graphics2D)g;
        Rectangle bounds = prnG2D.getDeviceConfiguration().getBounds();
        double padding = (pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2.0;
        double absPadding = (double)bounds.width / pageFormat.getWidth() * padding;
        bounds.width = (int)((double)bounds.width - absPadding * 2.0);
        bounds.height = (int)((double)bounds.height - absPadding * 2.0);
        double scalex = bounds.width / originalSize.width;
        double scaley = bounds.height / originalSize.height;
        double scale = Math.min(scalex, scaley);
        if (scale > 5.0) {
            scale = 5.0;
        }
        final JComponent canvas = root.toSwing(this.varMap, scale);
        BufferedImage bim1 = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 10);
        final Graphics2D bimg = bim1.createGraphics();
        bimg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        bimg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        bimg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bimg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                canvas.paint(bimg);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exep) {
            throw new PrinterException(exep.getMessage());
        }
        prnG2D.drawImage(bim1, AffineTransform.getScaleInstance(1.0 / scale, 1.0 / scale), canvas);
        return 0;
    }

    private RootElement loadTemplate() {
        RootElement root = null;
        File tplFile = new File("./temp", this.tplPath);
        if (tplFile.exists() && tplFile.isFile()) {
            root = (RootElement)JAXB.unmarshal((URI)tplFile.toURI(), RootElement.class);
        } else {
            ClassLoader cl = this.getClass().getClassLoader();
            root = (RootElement)JAXB.unmarshal((URL)cl.getResource(this.tplPath), RootElement.class);
        }
        return root;
    }
}

