/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.awt;

import in.gov.uidai.ec.icas.util.OS;
import in.gov.uidai.ec.print.impl.AbstractReceiptPrinter;
import in.gov.uidai.ec.print.impl.awt.AwtReceipt;
import in.gov.uidai.ec.service.receipt.PrintRequest;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwtReceiptPrinter
extends AbstractReceiptPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwtReceiptPrinter.class);
    private static final String PREFIX_ADD_TPL = "/enrol-add";
    private static final String PREFIX_UPDATE_TPL = "/enrol-update";
    private static final String PREFIX_DOC_UPDATE_TPL = "/enrol-doc-update";

    public boolean print(PrintRequest request) {
        this.updateVarMap(request);
        AwtReceipt receipt = new AwtReceipt(this.getTemplatePath(request), request.getVarMap());
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (StringUtils.isNotBlank((String)request.getJobName())) {
            printJob.setJobName(request.getJobName());
        } else {
            String jobName = "AADHAAR-RECEIPT-" + Long.toString(System.currentTimeMillis(), 36).toUpperCase();
            printJob.setJobName(jobName);
        }
        PageFormat pf = printJob.getPageFormat(null);
        this.maximizePrintArea(pf);
        printJob.setPrintable(receipt, pf);
        HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
        attr.add(MediaSizeName.ISO_A4);
        attr.add(OrientationRequested.PORTRAIT);
        if (OS.IsWindows()) {
            attr.add(new Copies(2));
        }
        if (printJob.printDialog(attr)) {
            try {
                printJob.print();
            }
            catch (Exception exep) {
                LOGGER.error("error during printing ", (Throwable)exep);
                return false;
            }
        }
        return true;
    }

    public byte[] printToFile(PrintRequest request) {
        this.updateVarMap(request);
        AwtReceipt receipt = new AwtReceipt(this.getTemplatePath(request), request.getVarMap());
        try {
            return receipt.printToFile();
        }
        catch (Exception exep) {
            LOGGER.error(exep.toString(), (Throwable)exep);
            return null;
        }
    }

    private String getTemplatePath(PrintRequest request) {
        String tplPath;
        String locale = request.getLocale().toLowerCase();
        boolean isRegConfForPaymentReceipt = request.getVarMap().containsKey("isRegConfForPaymentReceipt");
        String templatePath = isRegConfForPaymentReceipt ? "res/print/awt/single/gst" : "res/print/awt/single";
        switch (request.getReceiptType()) {
            case ENROL: {
                tplPath = templatePath + PREFIX_ADD_TPL + "_" + locale + ".xml";
                break;
            }
            case ENROL_UPDATE: {
                tplPath = templatePath + PREFIX_UPDATE_TPL + "_" + locale + ".xml";
                break;
            }
            case ENROL_DOC_UPDATE: {
                tplPath = templatePath + PREFIX_DOC_UPDATE_TPL + "_" + locale + ".xml";
                break;
            }
            default: {
                return request.getTemplate();
            }
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl.getResource(tplPath) != null) {
            return tplPath;
        }
        switch (request.getReceiptType()) {
            case ENROL: {
                tplPath = templatePath + PREFIX_ADD_TPL + ".xml";
                break;
            }
            case ENROL_UPDATE: {
                tplPath = templatePath + PREFIX_UPDATE_TPL + ".xml";
                break;
            }
            case ENROL_DOC_UPDATE: {
                tplPath = templatePath + PREFIX_DOC_UPDATE_TPL + ".xml";
                break;
            }
            default: {
                tplPath = request.getTemplate();
            }
        }
        return tplPath;
    }

    private void maximizePrintArea(PageFormat pageFormat) {
        double margin = 14.285714285714286;
        Paper paper = pageFormat.getPaper();
        double width = paper.getWidth() - margin * 2.0;
        double height = paper.getHeight() - margin * 2.0;
        paper.setImageableArea(margin, margin, width, height);
        pageFormat.setPaper(paper);
    }

    public byte[] printPreview(PrintRequest request) {
        return new byte[0];
    }
}

