/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageBox
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageBox.class);
    private Image theImg;
    private int halign;
    private int valign;
    private boolean dynaSize;
    private boolean aspectRatio;

    public void setImage(Image img) {
        this.theImg = img;
    }

    public void setImage(URL path) {
        try {
            this.theImg = ImageIO.read(path);
        }
        catch (Exception exep) {
            LOGGER.warn("image not loaded " + path, (Throwable)exep);
        }
    }

    public void setHorizontalAlignment(int align) {
        this.halign = align;
    }

    public void setVerticalAlignment(int align) {
        this.valign = align;
    }

    public void setDynamicSize(boolean flag) {
        this.dynaSize = flag;
    }

    public void setAspectRatio(boolean flag) {
        this.aspectRatio = flag;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.theImg == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = this.getSize();
        int iwidth = this.theImg.getWidth(this);
        int iheight = this.theImg.getHeight(this);
        if (this.dynaSize) {
            double scalex = (double)size.width * 1.0 / ((double)iwidth * 1.0);
            double scaley = (double)size.height * 1.0 / ((double)iheight * 1.0);
            if (this.aspectRatio) {
                double scale = Math.min(scalex, scaley);
                int swidth = (int)((double)iwidth * scale);
                int sheight = (int)((double)iheight * scale);
                int posx = 0;
                int posy = 0;
                if (this.halign == 4) {
                    posx = size.width - swidth;
                } else if (this.halign == 0) {
                    posx = size.width / 2 - swidth / 2;
                }
                if (this.valign == 3) {
                    posx = size.height - sheight;
                } else if (this.valign == 0) {
                    posy = size.height / 2 - sheight / 2;
                }
                g2d.translate(posx, posy);
                g2d.scale(scale, scale);
            } else {
                g2d.scale(scalex, scaley);
            }
            g2d.drawImage(this.theImg, 0, 0, this);
        } else {
            int posx = 0;
            int posy = 0;
            if (this.halign == 4) {
                posx = size.width - iwidth;
            } else if (this.halign == 0) {
                posx = size.width / 2 - iwidth / 2;
            }
            if (this.valign == 3) {
                posx = size.height - iheight;
            } else if (this.valign == 0) {
                posy = size.height / 2 - iheight / 2;
            }
            g2d.drawImage(this.theImg, posx, posy, this);
        }
    }
}

