/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.awt;

import in.gov.uidai.ec.print.impl.awt.ImageBox;
import in.gov.uidai.ec.print.impl.awt.PrintTemplateElement;
import java.awt.Image;
import java.net.URL;
import java.util.Map;
import javax.swing.JComponent;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.commons.lang.StringUtils;

public class ImageElement
extends PrintTemplateElement {
    private String key;
    private String imgPath;
    private int halign;
    private int valign;
    private boolean sizeToFit;
    private boolean aspectRatio;

    @XmlAttribute(name="key")
    public void setKey(String key) {
        this.key = key;
    }

    @XmlAttribute(name="src")
    public void setSource(String path) {
        this.imgPath = path;
    }

    @XmlAttribute(name="halign")
    public void setHalign(String align) {
        if (StringUtils.isBlank((String)align)) {
            return;
        }
        if (align.equalsIgnoreCase("left")) {
            this.halign = 2;
        }
        if (align.equalsIgnoreCase("right")) {
            this.halign = 4;
        }
        if (align.equalsIgnoreCase("center")) {
            this.halign = 0;
        }
        if (align.equalsIgnoreCase("middle")) {
            this.halign = 0;
        }
    }

    @XmlAttribute(name="valign")
    public void setValign(String align) {
        if (StringUtils.isBlank((String)align)) {
            return;
        }
        if (align.equalsIgnoreCase("top")) {
            this.valign = 1;
        }
        if (align.equalsIgnoreCase("bottom")) {
            this.valign = 3;
        }
        if (align.equalsIgnoreCase("center")) {
            this.valign = 0;
        }
        if (align.equalsIgnoreCase("middle")) {
            this.valign = 0;
        }
    }

    @XmlAttribute(name="size-to-fit")
    public void setSizeToFit(boolean flag) {
        this.sizeToFit = flag;
    }

    @XmlAttribute(name="aspect-ratio")
    public void setAspectRatio(boolean flag) {
        this.aspectRatio = flag;
    }

    @Override
    protected JComponent createComponent(Map<String, Object> varMap, double scale) {
        Object value;
        ImageBox result = new ImageBox();
        result.setHorizontalAlignment(this.halign);
        result.setVerticalAlignment(this.valign);
        result.setDynamicSize(this.sizeToFit);
        result.setAspectRatio(this.aspectRatio);
        if (StringUtils.isNotBlank((String)this.key) && (value = varMap.get(this.key)) instanceof Image) {
            result.setImage((Image)value);
            return result;
        }
        if (StringUtils.isNotBlank((String)this.imgPath)) {
            try {
                URL url = this.getClass().getClassLoader().getResource(this.imgPath);
                result.setImage(url);
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

