/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.awt;

import in.gov.uidai.swing.fontman.FontManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang.StringUtils;

public abstract class PrintTemplateElement {
    private Dimension size = new Dimension(0, 0);
    private Point location = new Point(0, 0);
    private Color background;
    private Color foreground;
    private String value;
    private String visibleIfKey;
    private Font font;
    private boolean display = true;
    private List<PrintTemplateElement> nestedElements = new ArrayList<PrintTemplateElement>();

    protected PrintTemplateElement() {
    }

    @XmlAttribute(name="visibleifkey")
    public final void setVisibleIfKey(String key) {
        this.visibleIfKey = key;
    }

    @XmlAttribute(name="display")
    public final void setDisplay(boolean key) {
        this.display = key;
    }

    @XmlAttribute(name="width")
    public final void setWidth(int width) {
        this.size.width = width;
    }

    @XmlAttribute(name="height")
    public final void setHeight(int height) {
        this.size.height = height;
    }

    @XmlAttribute(name="x")
    public final void setX(int x) {
        this.location.x = x;
    }

    @XmlAttribute(name="y")
    public final void setY(int y) {
        this.location.y = y;
    }

    @XmlAttribute(name="background")
    public final void setBackground(String color) {
        try {
            this.background = Color.decode(color);
        }
        catch (Exception exep) {
            this.background = null;
            throw new RuntimeException("Error during setting background", exep);
        }
    }

    @XmlAttribute(name="foreground")
    public final void setForeground(String color) {
        try {
            this.foreground = Color.decode(color);
        }
        catch (Exception exep) {
            this.foreground = Color.BLACK;
            throw new RuntimeException("Error during setting foreground", exep);
        }
    }

    @XmlAttribute(name="font")
    public final void setFont(String spec) {
        if (spec.indexOf(58) >= 0) {
            String[] parts = spec.split("\\:");
            if (parts.length < 3) {
                return;
            }
            String fontName = parts[0];
            int size = 10;
            try {
                size = Integer.parseInt(parts[1]);
            }
            catch (Exception ignored) {
                throw new RuntimeException("Error during setting font", ignored);
            }
            int style = 0;
            if (parts[2].equalsIgnoreCase("bold")) {
                style = 1;
            } else if (parts[2].equalsIgnoreCase("italic")) {
                style = 2;
            } else if (parts[2].equalsIgnoreCase("bold-italic")) {
                style = 3;
            }
            this.font = StringUtils.endsWithIgnoreCase((String)fontName, (String)".ttf") ? FontManager.getInst().getPrintFont(fontName, style, size) : FontManager.getInst().getPrintFontForLocale(fontName, style, size);
        } else {
            this.font = Font.decode(spec);
        }
    }

    @XmlValue
    public final void setValue(String value) {
        this.value = value;
    }

    protected final void setNestedElement(PrintTemplateElement element) {
        this.nestedElements.add(element);
    }

    protected final String getValue() {
        return this.value;
    }

    public final Dimension getSize() {
        return this.size;
    }

    public final JComponent toSwing(Map<String, Object> varMap, double scale) {
        JComponent result = this.createComponent(varMap, scale);
        if (StringUtils.isNotBlank((String)this.visibleIfKey) && !varMap.containsKey(this.visibleIfKey)) {
            result.setVisible(false);
            return result;
        }
        result.setVisible(this.display);
        result.setLayout(null);
        this.size.width = (int)((double)this.size.width * scale);
        this.size.height = (int)((double)this.size.height * scale);
        result.setSize(this.size);
        this.location.x = (int)((double)this.location.x * scale);
        this.location.y = (int)((double)this.location.y * scale);
        result.setLocation(this.location);
        if (this.background == null) {
            result.setOpaque(false);
        } else {
            result.setOpaque(true);
        }
        result.setBackground(this.background);
        if (this.foreground != null) {
            result.setForeground(this.foreground);
        }
        if (this.font != null) {
            this.font = this.font.deriveFont(this.font.getStyle(), (float)((double)this.font.getSize() * scale));
            result.setFont(this.font);
        }
        for (PrintTemplateElement element : this.nestedElements) {
            JComponent comp = element.toSwing(varMap, scale);
            if (comp == null) continue;
            result.add(comp);
        }
        return result;
    }

    protected abstract JComponent createComponent(Map<String, Object> var1, double var2);
}

