/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.awt;

import in.gov.uidai.ec.print.impl.awt.PrintTemplateElement;
import java.awt.ComponentOrientation;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.commons.lang.StringUtils;

public class TextElement
extends PrintTemplateElement {
    private String key;
    private int halign;
    private int valign;
    private boolean html;
    private ComponentOrientation compor = ComponentOrientation.LEFT_TO_RIGHT;

    @XmlAttribute(name="key")
    public void setKey(String key) {
        this.key = key;
    }

    @XmlAttribute(name="html")
    public void setHtml(boolean flag) {
        this.html = flag;
    }

    @XmlAttribute(name="halign")
    public void setHalign(String align) {
        if (StringUtils.isBlank((String)align)) {
            return;
        }
        if (align.equalsIgnoreCase("left")) {
            this.halign = 2;
        }
        if (align.equalsIgnoreCase("right")) {
            this.halign = 4;
        }
        if (align.equalsIgnoreCase("center")) {
            this.halign = 0;
        }
        if (align.equalsIgnoreCase("middle")) {
            this.halign = 0;
        }
    }

    @XmlAttribute(name="valign")
    public void setValign(String align) {
        if (StringUtils.isBlank((String)align)) {
            return;
        }
        if (align.equalsIgnoreCase("top")) {
            this.valign = 1;
        }
        if (align.equalsIgnoreCase("bottom")) {
            this.valign = 3;
        }
        if (align.equalsIgnoreCase("center")) {
            this.valign = 0;
        }
        if (align.equalsIgnoreCase("middle")) {
            this.valign = 0;
        }
    }

    @XmlAttribute(name="orientation")
    public final void setOrientation(String value) {
        this.compor = StringUtils.equalsIgnoreCase((String)value, (String)"rtl") ? ComponentOrientation.RIGHT_TO_LEFT : (StringUtils.equalsIgnoreCase((String)value, (String)"ltr") ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.UNKNOWN);
    }

    @Override
    protected JComponent createComponent(Map<String, Object> varMap, double scale) {
        Object value;
        JLabel result = new JLabel();
        result.setComponentOrientation(this.compor);
        result.setHorizontalAlignment(this.halign);
        result.setHorizontalTextPosition(this.halign);
        result.setVerticalAlignment(this.valign);
        result.setVerticalTextPosition(this.valign);
        if (StringUtils.isNotBlank((String)this.key) && (value = varMap.get(this.key)) != null) {
            if (this.html) {
                result.setText("<html>" + value.toString() + "</html>");
            } else {
                result.setText(value.toString());
            }
            return result;
        }
        if (this.getValue() != null) {
            if (this.html) {
                result.setText("<html>" + this.keySubstitute(this.getValue(), varMap) + "</html>");
            } else {
                result.setText(this.keySubstitute(this.getValue(), varMap));
            }
        }
        return result;
    }

    private String keySubstitute(String input, Map<String, Object> varMap) {
        Pattern pattern = Pattern.compile("\\$\\{[a-zA-Z0-9\\.\\-_]+\\}");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer(input);
        while (matcher.find()) {
            MatchResult mr = matcher.toMatchResult();
            String key = mr.group().substring(2, mr.group().length() - 1);
            String value = null;
            if (varMap.containsKey(key) && varMap.get(key) != null) {
                value = varMap.get(key).toString();
            }
            int start = mr.start();
            int end = mr.end();
            if (value != null) {
                result.replace(start, end, value);
            } else {
                result.replace(start, end, "");
            }
            matcher.reset();
            matcher = pattern.matcher(result.toString());
        }
        return result.toString();
    }
}

