/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.html;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlBuilder {
    private File rootFolder;
    private String bodyText;
    private Map<String, byte[]> attachments;
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlBuilder.class);

    public HtmlBuilder(File root) {
        this.rootFolder = root;
        boolean result = this.rootFolder.mkdirs();
        if (result) {
            LOGGER.info("Directory created");
        } else {
            LOGGER.info("Directory not created");
        }
        this.attachments = new HashMap<String, byte[]>();
    }

    public void setBodyText(String text) {
        this.bodyText = text;
    }

    public void addAttachment(String path, byte[] data) {
        this.attachments.put(path, data);
    }

    public void addClasspathAttachment(String path) throws IOException {
        int oneByte;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        InputStream input = cl.getResourceAsStream(path);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] chunk = new byte[4096];
        while ((oneByte = input.read()) >= 0) {
            buffer.write(oneByte);
            int amt = input.read(chunk);
            buffer.write(chunk, 0, amt);
        }
        input.close();
        buffer.flush();
        buffer.close();
        byte[] imgData = buffer.toByteArray();
        this.attachments.put(path, imgData);
    }

    public void addImageAttachment(String path, BufferedImage image) throws IOException {
        String name = null;
        name = StringUtils.endsWithIgnoreCase((String)path, (String)".jpg") ? path : (StringUtils.endsWithIgnoreCase((String)path, (String)".jpeg") ? path : path + ".jpg");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "JPEG", buffer);
        buffer.flush();
        buffer.close();
        byte[] imgData = buffer.toByteArray();
        this.attachments.put(name, imgData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        OutputStreamWriter writer = null;
        OutputStream fos = null;
        try {
            writer = new FileWriter(new File(this.rootFolder, "print.html"));
            writer.write(this.bodyText);
            Set<String> keys = this.attachments.keySet();
            for (String path : keys) {
                File f = new File(this.rootFolder, path);
                File canonicalFile = f.getCanonicalFile();
                if (!canonicalFile.getPath().startsWith(this.rootFolder.getCanonicalPath())) {
                    LOGGER.error("Attempt to manipulate file path");
                }
                if (f.getParentFile().mkdirs()) {
                    LOGGER.info("Directory created");
                } else {
                    LOGGER.info("Directory not created");
                }
                fos = new FileOutputStream(f);
                ((FileOutputStream)fos).write(this.attachments.get(path));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            if (fos != null) {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
        }
    }

    public File getPrintFile() {
        return new File(this.rootFolder, "print.html");
    }
}

