/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.html;

import in.gov.uidai.ec.print.impl.AbstractReceiptPrinter;
import in.gov.uidai.ec.print.impl.html.HtmlBuilder;
import in.gov.uidai.ec.print.impl.multi.IReceiptPrinterPreference;
import in.gov.uidai.ec.service.receipt.PrintRequest;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReceiptPrinter
extends AbstractReceiptPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReceiptPrinter.class);
    private static final String ENROL_ADD_TEMPLATE = "/enrol-add.html";
    private static final String ENROL_UPDATE_TEMPLATE = "/enrol-update.html";
    private static final String ENROL_DOC_UPDATE_TEMPLATE = "/enrol-doc-update.html";
    private static final String ENROL_ADD_ATTLIST = "res/print/html/enrol-add.att.list";
    private static final String ENROL_UPDATE_ATTLIST = "res/print/html/enrol-update.att.list";
    private static final String TEMP_PATH = "./temp";
    private IReceiptPrinterPreference rpp;

    public void setPreference(IReceiptPrinterPreference pref) {
        this.rpp = pref;
        LOGGER.debug("done");
    }

    public boolean print(PrintRequest request) {
        HtmlBuilder htmlBuilder = new HtmlBuilder(new File(TEMP_PATH));
        if (!this.generateTemplates(request, htmlBuilder)) {
            return false;
        }
        try {
            this.printFile(htmlBuilder.getPrintFile(), false);
        }
        catch (Exception e) {
            LOGGER.error("print error", (Throwable)e);
        }
        return true;
    }

    public byte[] printToFile(PrintRequest request) {
        HtmlBuilder htmlBuilder = new HtmlBuilder(new File(TEMP_PATH));
        if (!this.generateTemplates(request, htmlBuilder)) {
            return null;
        }
        try {
            this.printFile(htmlBuilder.getPrintFile(), true);
        }
        catch (Exception e) {
            LOGGER.error("print error", (Throwable)e);
        }
        return null;
    }

    private String getTemplatePath(PrintRequest request) {
        String templatePath = request.getVarMap().containsKey("isRegConfForPaymentReceipt") ? "res/print/html/gst" : "res/print/html";
        switch (request.getReceiptType()) {
            case ENROL: {
                return templatePath + ENROL_ADD_TEMPLATE;
            }
            case ENROL_UPDATE: {
                return templatePath + ENROL_UPDATE_TEMPLATE;
            }
            case ENROL_DOC_UPDATE: {
                return templatePath + ENROL_DOC_UPDATE_TEMPLATE;
            }
        }
        return request.getTemplate();
    }

    private boolean generateTemplates(PrintRequest request, HtmlBuilder htmlBuilder) {
        this.updateVarMap(request);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        VelocityEngine ve = new VelocityEngine();
        try {
            InputStream propin = cl.getResourceAsStream("res/print/html/velocity.properties");
            Properties vprops = new Properties();
            vprops.load(propin);
            propin.close();
            ve.init(vprops);
        }
        catch (Exception exep) {
            LOGGER.error("velocity init error", (Throwable)exep);
            return false;
        }
        Template template = ve.getTemplate(this.getTemplatePath(request));
        VelocityContext vc = new VelocityContext(request.getVarMap());
        StringWriter vout = new StringWriter();
        template.merge((Context)vc, (Writer)vout);
        try {
            htmlBuilder.setBodyText(new String(vout.toString().getBytes("UTF-8")));
            this.populateStaticAttachments(request, htmlBuilder);
            this.populateDynamicAttachments(request, htmlBuilder);
            htmlBuilder.save();
        }
        catch (Exception exep) {
            LOGGER.error("print error", (Throwable)exep);
            return false;
        }
        return true;
    }

    private void populateStaticAttachments(PrintRequest request, HtmlBuilder htmlBuilder) throws IOException {
        String attList = null;
        switch (request.getReceiptType()) {
            case ENROL: {
                attList = ENROL_ADD_ATTLIST;
                break;
            }
            case ENROL_UPDATE: {
                attList = ENROL_UPDATE_ATTLIST;
                break;
            }
            case ENROL_DOC_UPDATE: {
                attList = ENROL_UPDATE_ATTLIST;
                break;
            }
            default: {
                attList = null;
            }
        }
        if (StringUtils.isBlank((String)attList)) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try (InputStream clin = cl.getResourceAsStream(attList);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(clin));
            String oneLine = null;
            while ((oneLine = reader.readLine()) != null) {
                if (StringUtils.isBlank((String)oneLine) || oneLine.startsWith("#")) continue;
                htmlBuilder.addClasspathAttachment(oneLine.trim());
            }
        }
    }

    private void populateDynamicAttachments(PrintRequest request, HtmlBuilder htmlBuilder) throws IOException {
        Map varMap = request.getVarMap();
        Set keys = varMap.keySet();
        for (String key : keys) {
            if (!(varMap.get(key) instanceof BufferedImage)) continue;
            htmlBuilder.addImageAttachment(key, (BufferedImage)varMap.get(key));
        }
    }

    protected void printFile(File prnFile, boolean isPreview) throws Exception {
        String osName = System.getProperty("os.name");
        if (StringUtils.startsWithIgnoreCase((String)osName, (String)"win")) {
            if (isPreview) {
                String cli = "\"c:\\program files\\mozilla firefox\\firefox.exe\" \"{0}\" ";
                if (this.rpp != null) {
                    cli = this.rpp.getHtmlCliWindows(cli);
                }
                cli = StringUtils.replace((String)cli, (String)"-print", (String)"");
                cli = MessageFormat.format(cli, prnFile.getCanonicalPath());
                Process p = Runtime.getRuntime().exec(cli);
                if (p.waitFor() == 0) {
                    LOGGER.info("Process completed");
                } else {
                    LOGGER.info("Process not completed");
                }
            } else {
                Desktop.getDesktop().print(prnFile.getCanonicalFile());
            }
        } else if (StringUtils.startsWithIgnoreCase((String)osName, (String)"linux")) {
            String cli = "/usr/bin/firefox -print file:///{0}";
            if (this.rpp != null) {
                cli = this.rpp.getHtmlCliLinux(cli);
            }
            if (isPreview) {
                cli = StringUtils.replace((String)cli, (String)"-print", (String)"");
            }
            cli = MessageFormat.format(cli, prnFile.getCanonicalPath());
            Process p = Runtime.getRuntime().exec(cli);
            if (p.waitFor() == 0) {
                LOGGER.info("Process completed");
            } else {
                LOGGER.info("Process not completed");
            }
        }
    }

    public byte[] printPreview(PrintRequest request) {
        return new byte[0];
    }
}

