/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.multi;

import in.gov.uidai.ec.icas.util.OS;
import in.gov.uidai.ec.print.impl.multi.IReceiptPrinterPreference;
import in.gov.uidai.ec.service.receipt.IReceiptPrinter;
import in.gov.uidai.ec.service.receipt.PrintRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MultiReceiptPrinter
implements ApplicationContextAware,
IReceiptPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiReceiptPrinter.class);
    private ApplicationContext appCtxt;
    private IReceiptPrinterPreference rpp;

    public void setApplicationContext(ApplicationContext ctxt) {
        this.appCtxt = ctxt;
        LOGGER.debug("done");
    }

    public void setPreference(IReceiptPrinterPreference pref) {
        this.rpp = pref;
        LOGGER.debug("done");
    }

    public boolean print(PrintRequest request) {
        String prnMthd = this.rpp.getPrintMethod("awt");
        String localLang = request.getVarMap().get("localLang").toString();
        if (OS.IsLinux()) {
            prnMthd = "html";
        }
        if (StringUtils.isBlank((String)prnMthd)) {
            LOGGER.error("print method not defined");
            return false;
        }
        IReceiptPrinter printer = null;
        try {
            printer = (IReceiptPrinter)this.appCtxt.getBean(prnMthd, IReceiptPrinter.class);
        }
        catch (Exception exep) {
            LOGGER.error("no suitable receipt printer found for method " + prnMthd);
            return false;
        }
        try {
            return printer.print(request);
        }
        catch (Exception exep) {
            LOGGER.error("encountered", (Throwable)exep);
            return false;
        }
    }

    public byte[] printToFile(PrintRequest request) {
        String prnFileMthd = this.rpp.getPrintToFileMethod("awt");
        if (StringUtils.isBlank((String)prnFileMthd)) {
            LOGGER.error("print to file method not defined");
            return null;
        }
        IReceiptPrinter printer = null;
        try {
            printer = (IReceiptPrinter)this.appCtxt.getBean(prnFileMthd, IReceiptPrinter.class);
        }
        catch (Exception exep) {
            LOGGER.error("no suitable receipt printer found for method " + prnFileMthd);
            return null;
        }
        try {
            return printer.printToFile(request);
        }
        catch (Exception exep) {
            LOGGER.error(exep.toString(), (Throwable)exep);
            return null;
        }
    }

    public byte[] printPreview(PrintRequest request) {
        String prnMthd = this.rpp.getPrintMethod("awt");
        if (StringUtils.isBlank((String)prnMthd)) {
            LOGGER.error("print method not defined");
            return new byte[0];
        }
        IReceiptPrinter printer = null;
        try {
            printer = (IReceiptPrinter)this.appCtxt.getBean(prnMthd, IReceiptPrinter.class);
        }
        catch (Exception exep) {
            LOGGER.error("no suitable receipt printer found for method " + prnMthd);
            return new byte[0];
        }
        try {
            return printer.printPreview(request);
        }
        catch (Exception exep) {
            LOGGER.error("encountered", (Throwable)exep);
            return new byte[0];
        }
    }
}

