/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.print.impl.vfop;

import in.gov.uidai.ec.print.impl.AbstractReceiptPrinter;
import in.gov.uidai.ec.service.receipt.PrintRequest;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfopReceiptPrinter
extends AbstractReceiptPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VfopReceiptPrinter.class);
    private static final String ENROL_ADD_TEMPLATE = "res/print/vfop/enrol-add.vfop";
    private static final String ENROL_UPDATE_TEMPLATE = "res/print/vfop/enrol-update.vfop";

    public boolean print(PrintRequest request) {
        this.updateVarMap(request);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        VelocityEngine ve = new VelocityEngine();
        try {
            InputStream propin = cl.getResourceAsStream("res/print/vfop/velocity.properties");
            Properties vprops = new Properties();
            vprops.load(propin);
            propin.close();
            ve.init(vprops);
        }
        catch (Exception exep) {
            LOGGER.error("velocity init error", (Throwable)exep);
            return false;
        }
        Template template = ve.getTemplate(this.getTemplatePath(request));
        VelocityContext vc = new VelocityContext(request.getVarMap());
        StringWriter vout = new StringWriter();
        template.merge((Context)vc, (Writer)vout);
        StreamSource src = new StreamSource(new StringReader(vout.getBuffer().toString()));
        try {
            FopFactory fopFactory = FopFactory.newInstance();
            fopFactory.setUserConfig(cl.getResource("res/print/vfop/fop.xconf").toString());
            FOUserAgent foua = fopFactory.newFOUserAgent();
            foua.setTitle(request.getJobName());
            Fop fop = fopFactory.newFop("application/X-fop-print", foua);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Transformer transformer = factory.newTransformer();
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (Exception exep) {
            LOGGER.error("fop error", (Throwable)exep);
            return false;
        }
        return true;
    }

    public byte[] printToFile(PrintRequest request) {
        return null;
    }

    public byte[] printPreview(PrintRequest request) {
        return new byte[0];
    }

    private String getTemplatePath(PrintRequest request) {
        switch (request.getReceiptType()) {
            case ENROL: {
                return ENROL_ADD_TEMPLATE;
            }
            case ENROL_UPDATE: {
                return ENROL_UPDATE_TEMPLATE;
            }
        }
        return request.getTemplate();
    }
}

