/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db;

import in.gov.uidai.ec.db.DerbyDBService;
import in.gov.uidai.ec.db.DerbyDataSource;
import in.gov.uidai.ec.db.RuntimeDBSpringConfig;
import java.io.InputStream;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@Import(value={RuntimeDBSpringConfig.class})
public class DBSpringConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBSpringConfig.class);
    private static final Properties LOCALE_OPTIONS = new Properties();

    @Bean
    DerbyDBService derbyDBService() {
        return new DerbyDBService();
    }

    @Bean(name={"ds.registrar"}, destroyMethod="close")
    DerbyDataSource registrarDataSource() {
        DerbyDataSource dds = new DerbyDataSource();
        dds.setDriverClassName("org.apache.derby.jdbc.ClientDriver");
        dds.setUrl("jdbc:derby:registrar;dataEncryption=true;encryptionAlgorithm=AES/CBC/NoPadding;bootPassword=" + LOCALE_OPTIONS.getProperty("bootPassword"));
        return dds;
    }

    @Bean(name={"tm.registrar"})
    DataSourceTransactionManager registrarTransactionManager() {
        return new DataSourceTransactionManager((DataSource)((Object)this.registrarDataSource()));
    }

    @Bean(name={"ds.runtime"}, destroyMethod="close")
    DerbyDataSource runtimeDataSource() {
        DerbyDataSource dds = new DerbyDataSource();
        dds.setDriverClassName("org.apache.derby.jdbc.EmbeddedDriver");
        dds.setUrl("jdbc:derby:runtime;dataEncryption=true;encryptionAlgorithm=AES/CBC/NoPadding;bootPassword=" + LOCALE_OPTIONS.getProperty("bootPassword"));
        return dds;
    }

    @Bean(name={"tm.runtime"})
    DataSourceTransactionManager runtimeTransactionManager() {
        DataSourceTransactionManager tm = new DataSourceTransactionManager((DataSource)((Object)this.runtimeDataSource()));
        return tm;
    }

    static {
        ClassLoader cl = RuntimeDBSpringConfig.class.getClassLoader();
        InputStream input = cl.getResourceAsStream("password.properties");
        try {
            LOCALE_OPTIONS.load(input);
            input.close();
        }
        catch (Exception exep) {
            LOGGER.info("unable to load locale options", (Throwable)exep);
        }
    }
}

