/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyDBDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbyDBDeployer.class);
    private static final String DERBY_SYSTEM_HOME = "./data/derbydb";
    private static final String DERBY_IMPORT_HOME = "./data/import";
    private static final String TRIGGER_PREFIX = "__deploy_";
    private DataSource dataSource;
    private ArrayList<IMigrationQuery> migrationQueriesList;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setMigrationQueriesList(ArrayList<IMigrationQuery> migrationQueriesList) {
        this.migrationQueriesList = migrationQueriesList;
    }

    public void deploy() {
        this.deployDBImpl("registrar");
        this.deployDBImpl("runtime");
    }

    public void warmup(DataSource ds) {
        try {
            ds.getConnection();
        }
        catch (Exception exep) {
            LOGGER.error("db warm up failed", (Throwable)exep);
        }
    }

    public void runMigration() throws SQLException {
        try (Connection conn = this.dataSource.getConnection();){
            for (IMigrationQuery query : this.migrationQueriesList) {
                query.Execute(conn);
            }
        }
    }

    private void deployDBImpl(String dbName) {
        String triggerName = TRIGGER_PREFIX + dbName;
        File trigger = new File(DERBY_IMPORT_HOME, triggerName);
        if (!trigger.exists()) {
            return;
        }
        LOGGER.info("deploying db " + dbName);
        boolean status = this.deleteRecursive(new File(DERBY_SYSTEM_HOME, dbName));
        if (!status) {
            LOGGER.warn("could not completely delete db " + dbName);
            return;
        }
        try {
            this.extractArchive(new File(DERBY_IMPORT_HOME, dbName + ".zip"), new File(DERBY_SYSTEM_HOME));
        }
        catch (Exception exep) {
            LOGGER.warn(dbName + " db extraction failed!", (Throwable)exep);
            return;
        }
        if (!trigger.delete()) {
            trigger.deleteOnExit();
        }
    }

    private boolean deleteRecursive(File folder) {
        File[] files;
        if (!folder.exists()) {
            return true;
        }
        if (folder.isFile()) {
            return folder.delete();
        }
        boolean flag = true;
        for (File file : files = folder.listFiles()) {
            if (file.isFile()) {
                if (file.delete()) continue;
                flag = false;
                continue;
            }
            if (this.deleteRecursive(file)) continue;
            flag = false;
        }
        if (!folder.delete()) {
            flag = false;
        }
        return flag;
    }

    private void extractArchive(File arcFile, File targetDir) throws IOException {
        ZipInputStream zin = new ZipInputStream(new FileInputStream(arcFile));
        ZipEntry entry = null;
        while ((entry = zin.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            try {
                this.extractArchiveEntry(targetDir, entry, zin);
                LOGGER.debug("xtrct - " + entry.getName());
            }
            catch (Exception exep) {
                LOGGER.debug("xtrct failed - " + entry.getName(), (Throwable)exep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractArchiveEntry(File targetDir, ZipEntry entry, ZipInputStream zin) throws IOException {
        String entryName = entry.getName().replace('\\', '/').replace('/', File.separatorChar);
        File xfile = new File(targetDir, entryName).getCanonicalFile();
        if (!xfile.getPath().startsWith(targetDir.getCanonicalPath())) {
            LOGGER.error("Entry is outside the target dir");
        }
        if (xfile.getParentFile().mkdirs()) {
            LOGGER.info("Directory created");
        } else {
            LOGGER.info("Directory not created");
        }
        FileOutputStream fos = null;
        try {
            int size;
            fos = new FileOutputStream(xfile);
            byte[] buffer = new byte[10240];
            while ((size = zin.read(buffer, 0, buffer.length)) != -1) {
                fos.write(buffer, 0, size);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("xtrct failed - " + ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }

    static {
        System.setProperty("derby.system.home", DERBY_SYSTEM_HOME);
        LOGGER.debug("derby.system.home set to ./data/derbydb");
    }
}

