/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db;

import org.apache.derby.drda.NetworkServerControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DerbyDBService
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbyDBService.class);
    private static final String DERBY_SYSTEM_HOME = "./data/derbydb";

    public void afterPropertiesSet() {
        LOGGER.trace("starting derby server");
        System.setProperty("derby.system.home", DERBY_SYSTEM_HOME);
        LOGGER.debug("derby.system.home set to ./data/derbydb");
        System.setProperty("derby.storage.pageCacheSize", "1000");
        try {
            NetworkServerControl dbServ = new NetworkServerControl("127.0.0.1", "1527");
            dbServ.start(null);
            LOGGER.info("derby server started");
        }
        catch (Exception exep) {
            LOGGER.error("unable to start derby server", (Throwable)exep);
        }
    }

    public void destroy() {
        LOGGER.info("stopping derby server");
        try {
            NetworkServerControl dbServ = new NetworkServerControl();
            dbServ.shutdown();
        }
        catch (Exception exep) {
            LOGGER.error("unable to stop derby server", (Throwable)exep);
        }
    }
}

