/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db;

import in.gov.uidai.ec.db.RuntimeDBSpringConfig;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyDataSource
extends BasicDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbyDataSource.class);
    private static final Properties LOCALE_OPTIONS = new Properties();

    public synchronized void setUrl(String url) {
        super.setUrl(url);
    }

    public void setPassword(String password) {
        password = LOCALE_OPTIONS.getProperty("pass");
        super.setPassword(password);
    }

    public void setUsername(String username) {
        username = LOCALE_OPTIONS.getProperty("user");
        super.setUsername(username);
    }

    static {
        ClassLoader cl = RuntimeDBSpringConfig.class.getClassLoader();
        InputStream input = cl.getResourceAsStream("password.properties");
        try {
            LOCALE_OPTIONS.load(input);
            input.close();
        }
        catch (Exception exep) {
            LOGGER.info("unable to load locale options", (Throwable)exep);
        }
    }
}

