/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db;

import in.gov.uidai.ec.db.DerbyDBDeployer;
import in.gov.uidai.ec.db.DerbyDataSource;
import in.gov.uidai.ec.db.migrations.AddAndUpdateCreationDateColumnToPacketSummary;
import in.gov.uidai.ec.db.migrations.AddAppointmentIdColumnToPacketSummary;
import in.gov.uidai.ec.db.migrations.AddAutoMigrationStatusColumnToPacketSummary;
import in.gov.uidai.ec.db.migrations.AddEmailIdColumnInPacketSummary;
import in.gov.uidai.ec.db.migrations.AddFindAadhaarAttemptsTable;
import in.gov.uidai.ec.db.migrations.AddIsAutoSyncUploadSkippedToPacketSummary;
import in.gov.uidai.ec.db.migrations.AddIsNriAndIsdCodeColumnsAndUpdateMobileColumnInPacketSummary;
import in.gov.uidai.ec.db.migrations.AddMandatoryBiometricColumnToPacketSummary;
import in.gov.uidai.ec.db.migrations.AddProcessingAndPreProcessingStatusColumnsToPacketSummary;
import in.gov.uidai.ec.db.migrations.AddSubRejectReasonColumnToPacketSummary;
import in.gov.uidai.ec.db.migrations.AddUniqueConstraintToServerSyncDetailsActivityName;
import in.gov.uidai.ec.db.migrations.AlterTablePacketSummaryIncreaseHoldAndRejectReasonDescSize;
import in.gov.uidai.ec.db.migrations.CreateUCPacketsTable;
import in.gov.uidai.ec.db.migrations.DropObsoleteTables;
import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import in.gov.uidai.ec.db.migrations.UpdateFindAadhaarAttemptsTable;
import in.gov.uidai.ec.db.migrations.UpdatePacketSummaryUpdateStatusColumn;
import in.gov.uidai.ec.db.migrations.UpdatePktSkippedReasonColumnLengthInPacketSummary;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@EnableTransactionManagement
public class RuntimeDBSpringConfig
implements TransactionManagementConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeDBSpringConfig.class);
    private static final Properties LOCALE_OPTIONS = new Properties();

    @Bean(name={"ds.runtime"}, destroyMethod="close")
    DerbyDataSource runtimeDataSource() {
        DerbyDataSource dds = new DerbyDataSource();
        dds.setDriverClassName("org.apache.derby.jdbc.EmbeddedDriver");
        dds.setUrl("jdbc:derby:runtime;dataEncryption=true;encryptionAlgorithm=AES/CBC/NoPadding;bootPassword=" + LOCALE_OPTIONS.getProperty("bootPassword"));
        return dds;
    }

    @Bean(name={"tm.runtime"})
    DataSourceTransactionManager runtimeTransactionManager() {
        return new DataSourceTransactionManager((DataSource)((Object)this.runtimeDataSource()));
    }

    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return this.runtimeTransactionManager();
    }

    @Bean
    DerbyDBDeployer derbyDBDeployer() {
        DerbyDBDeployer dbDeployer = new DerbyDBDeployer();
        dbDeployer.setDataSource((DataSource)((Object)this.runtimeDataSource()));
        dbDeployer.setMigrationQueriesList(new ArrayList<IMigrationQuery>(Arrays.asList(new AddMandatoryBiometricColumnToPacketSummary(), new AddAutoMigrationStatusColumnToPacketSummary(), new AddUniqueConstraintToServerSyncDetailsActivityName(), new AddProcessingAndPreProcessingStatusColumnsToPacketSummary(), new UpdatePacketSummaryUpdateStatusColumn(), new AddAndUpdateCreationDateColumnToPacketSummary(), new AddAppointmentIdColumnToPacketSummary(), new AddIsAutoSyncUploadSkippedToPacketSummary(), new AddFindAadhaarAttemptsTable(), new AddIsNriAndIsdCodeColumnsAndUpdateMobileColumnInPacketSummary(), new UpdateFindAadhaarAttemptsTable(), new AlterTablePacketSummaryIncreaseHoldAndRejectReasonDescSize(), new AddEmailIdColumnInPacketSummary(), new UpdatePktSkippedReasonColumnLengthInPacketSummary(), new AddSubRejectReasonColumnToPacketSummary(), new DropObsoleteTables(), new CreateUCPacketsTable())));
        return dbDeployer;
    }

    static {
        ClassLoader cl = RuntimeDBSpringConfig.class.getClassLoader();
        InputStream input = cl.getResourceAsStream("password.properties");
        try {
            LOCALE_OPTIONS.load(input);
            input.close();
        }
        catch (Exception exep) {
            LOGGER.info("unable to load locale options", (Throwable)exep);
        }
    }
}

