/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAndUpdateCreationDateColumnToPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddAndUpdateCreationDateColumnToPacketSummary.class);
    private String add_creation_date_to_summary = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN PACKET_CREATION_DATE BIGINT DEFAULT NULL";
    private String query_for_all_eid_where_creation_date_is_null = "SELECT ENROL_ID, PACKET_CREATION_DATE FROM APP.PACKET_SUMMARY WHERE PACKET_CREATION_DATE IS NULL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        Statement statement = null;
        ResultSet eidSet = null;
        try {
            DatabaseMetaData dataBaseMetaData = connection.getMetaData();
            ResultSet packetCreationDateResultSet = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "PACKET_CREATION_DATE");
            if (packetCreationDateResultSet != null && packetCreationDateResultSet.next()) {
                LOGGER.info("PACKET_CREATION_DATE column addition: skipping because column already exists");
                return;
            }
            statement = connection.createStatement(1005, 1008);
            connection.setAutoCommit(false);
            statement.addBatch(this.add_creation_date_to_summary);
            statement.executeBatch();
            eidSet = statement.executeQuery(this.query_for_all_eid_where_creation_date_is_null);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            while (eidSet.next()) {
                String eid = eidSet.getString("ENROL_ID");
                try {
                    Date d = sdf.parse(eid.substring(14));
                    eidSet.updateLong("PACKET_CREATION_DATE", d.getTime());
                    eidSet.updateRow();
                }
                catch (Exception e) {
                    LOGGER.error("Error while migration. could not update creation date for eid ", (Throwable)e);
                }
            }
            connection.commit();
            connection.setAutoCommit(true);
            LOGGER.info("PACKET_CREATION_DATE  addition: Migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error("PACKET_CREATION_DATE addition:  Migration failed", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
            if (eidSet != null) {
                try {
                    eidSet.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

