/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAppointmentIdColumnToPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddAppointmentIdColumnToPacketSummary.class);
    private String add_appointment_id_col_if_not_exists = "ALTER TABLE APP.PACKET_SUMMARY ADD APPOINTMENT_ID VARCHAR(50) DEFAULT NULL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "APPOINTMENT_ID");
            if (rs != null && rs.next()) {
                LOGGER.info("skipping add_appointment_id_col_if_not_exists migration because column APPOINTMENT_ID already exists");
                return;
            }
            connection.createStatement().execute(this.add_appointment_id_col_if_not_exists);
            LOGGER.info("add_appointment_id_col_if_not_exists migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

