/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAutoMigrationStatusColumnToPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddAutoMigrationStatusColumnToPacketSummary.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "AUTO_MIGRATION_STATUS");
            if (rs != null && rs.next()) {
                LOGGER.info("skipping createAutoMigrationStatusIfNotExists migration because column AUTO_MIGRATION_STATUS already exists");
                String updatePendingAutoMigrationStatusToNull = "UPDATE APP.PACKET_SUMMARY SET AUTO_MIGRATION_STATUS = NULL where AUTO_MIGRATION_STATUS = 'PENDING'";
                connection.createStatement().execute(updatePendingAutoMigrationStatusToNull);
                LOGGER.info("updating AUTO_MIGRATION_STATUS to NULL if PENDING");
                return;
            }
            String createAutoMigrationStatusIfNotExists = "ALTER TABLE APP.PACKET_SUMMARY ADD AUTO_MIGRATION_STATUS VARCHAR(20) DEFAULT NULL";
            connection.createStatement().execute(createAutoMigrationStatusIfNotExists);
            LOGGER.info("createAutoMigrationStatusIfNotExists migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

